package zio.aws.iotwireless
import zio.aws.iotwireless.model.primitives.Use2DSolver.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.iotwireless.model.primitives.{
  DeviceCreationFile,
  SubBand,
  WirelessGatewayId,
  BeaconingFrequency,
  NetId,
  PresetFreq,
  MulticastGroupId,
  JoinEui,
  Coordinate,
  WirelessDeviceId,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountLinked extends Subtype[Boolean]
    type AccountLinked = zio.aws.iotwireless.model.primitives.AccountLinked.Type
    object AckModeRetryDurationSecs extends Subtype[Int]
    type AckModeRetryDurationSecs =
      zio.aws.iotwireless.model.primitives.AckModeRetryDurationSecs.Type
    object AddGwMetadata extends Subtype[Boolean]
    type AddGwMetadata = zio.aws.iotwireless.model.primitives.AddGwMetadata.Type
    object AmazonId extends Subtype[String]
    type AmazonId = zio.aws.iotwireless.model.primitives.AmazonId.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.iotwireless.model.primitives.AmazonResourceName.Type
    object ApId extends Subtype[String]
    type ApId = zio.aws.iotwireless.model.primitives.ApId.Type
    object AppEui extends Subtype[String]
    type AppEui = zio.aws.iotwireless.model.primitives.AppEui.Type
    object AppKey extends Subtype[String]
    type AppKey = zio.aws.iotwireless.model.primitives.AppKey.Type
    object AppSKey extends Subtype[String]
    type AppSKey = zio.aws.iotwireless.model.primitives.AppSKey.Type
    object AppServerPrivateKey extends Subtype[String]
    type AppServerPrivateKey =
      zio.aws.iotwireless.model.primitives.AppServerPrivateKey.Type
    object ApplicationServerPublicKey extends Subtype[String]
    type ApplicationServerPublicKey =
      zio.aws.iotwireless.model.primitives.ApplicationServerPublicKey.Type
    object AutoCreateTasks extends Subtype[Boolean]
    type AutoCreateTasks =
      zio.aws.iotwireless.model.primitives.AutoCreateTasks.Type
    object BCCH extends Subtype[Int]
    type BCCH = zio.aws.iotwireless.model.primitives.BCCH.Type
    object BSIC extends Subtype[Int]
    type BSIC = zio.aws.iotwireless.model.primitives.BSIC.Type
    object BaseLat extends Subtype[Float]
    type BaseLat = zio.aws.iotwireless.model.primitives.BaseLat.Type
    object BaseLng extends Subtype[Float]
    type BaseLng = zio.aws.iotwireless.model.primitives.BaseLng.Type
    object BaseStationId extends Subtype[Int]
    type BaseStationId = zio.aws.iotwireless.model.primitives.BaseStationId.Type
    object BeaconingDataRate extends Subtype[Int]
    type BeaconingDataRate =
      zio.aws.iotwireless.model.primitives.BeaconingDataRate.Type
    object BeaconingFrequency extends Subtype[Int]
    type BeaconingFrequency =
      zio.aws.iotwireless.model.primitives.BeaconingFrequency.Type
    object CaptureTimeAccuracy extends Subtype[Float]
    type CaptureTimeAccuracy =
      zio.aws.iotwireless.model.primitives.CaptureTimeAccuracy.Type
    object CdmaChannel extends Subtype[Int]
    type CdmaChannel = zio.aws.iotwireless.model.primitives.CdmaChannel.Type
    object CellParams extends Subtype[Int]
    type CellParams = zio.aws.iotwireless.model.primitives.CellParams.Type
    object CertificatePEM extends Subtype[String]
    type CertificatePEM =
      zio.aws.iotwireless.model.primitives.CertificatePEM.Type
    object CertificateValue extends Subtype[String]
    type CertificateValue =
      zio.aws.iotwireless.model.primitives.CertificateValue.Type
    object ChannelMask extends Subtype[String]
    type ChannelMask = zio.aws.iotwireless.model.primitives.ChannelMask.Type
    object ClassBTimeout extends Subtype[Int]
    type ClassBTimeout = zio.aws.iotwireless.model.primitives.ClassBTimeout.Type
    object ClassCTimeout extends Subtype[Int]
    type ClassCTimeout = zio.aws.iotwireless.model.primitives.ClassCTimeout.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.iotwireless.model.primitives.ClientRequestToken.Type
    object Coordinate extends Subtype[Float]
    type Coordinate = zio.aws.iotwireless.model.primitives.Coordinate.Type
    object Crc extends Subtype[Long]
    type Crc = zio.aws.iotwireless.model.primitives.Crc.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.iotwireless.model.primitives.CreatedAt.Type
    object CreationDate extends Subtype[Instant]
    type CreationDate = zio.aws.iotwireless.model.primitives.CreationDate.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime = zio.aws.iotwireless.model.primitives.CreationTime.Type
    object DakCertificateId extends Subtype[String]
    type DakCertificateId =
      zio.aws.iotwireless.model.primitives.DakCertificateId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iotwireless.model.primitives.Description.Type
    object DestinationArn extends Subtype[String]
    type DestinationArn =
      zio.aws.iotwireless.model.primitives.DestinationArn.Type
    object DestinationName extends Subtype[String]
    type DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName.Type
    object DevAddr extends Subtype[String]
    type DevAddr = zio.aws.iotwireless.model.primitives.DevAddr.Type
    object DevEui extends Subtype[String]
    type DevEui = zio.aws.iotwireless.model.primitives.DevEui.Type
    object DevStatusReqFreq extends Subtype[Int]
    type DevStatusReqFreq =
      zio.aws.iotwireless.model.primitives.DevStatusReqFreq.Type
    object DeviceCreationFile extends Subtype[String]
    type DeviceCreationFile =
      zio.aws.iotwireless.model.primitives.DeviceCreationFile.Type
    object DeviceName extends Subtype[String]
    type DeviceName = zio.aws.iotwireless.model.primitives.DeviceName.Type
    object DeviceProfileArn extends Subtype[String]
    type DeviceProfileArn =
      zio.aws.iotwireless.model.primitives.DeviceProfileArn.Type
    object DeviceProfileId extends Subtype[String]
    type DeviceProfileId =
      zio.aws.iotwireless.model.primitives.DeviceProfileId.Type
    object DeviceProfileName extends Subtype[String]
    type DeviceProfileName =
      zio.aws.iotwireless.model.primitives.DeviceProfileName.Type
    object DeviceTypeId extends Subtype[String]
    type DeviceTypeId = zio.aws.iotwireless.model.primitives.DeviceTypeId.Type
    object DlBucketSize extends Subtype[Int]
    type DlBucketSize = zio.aws.iotwireless.model.primitives.DlBucketSize.Type
    object DlDr extends Subtype[Int]
    type DlDr = zio.aws.iotwireless.model.primitives.DlDr.Type
    object DlFreq extends Subtype[Int]
    type DlFreq = zio.aws.iotwireless.model.primitives.DlFreq.Type
    object DlRate extends Subtype[Int]
    type DlRate = zio.aws.iotwireless.model.primitives.DlRate.Type
    object DlRatePolicy extends Subtype[String]
    type DlRatePolicy = zio.aws.iotwireless.model.primitives.DlRatePolicy.Type
    object DownlinkFrequency extends Subtype[Int]
    type DownlinkFrequency =
      zio.aws.iotwireless.model.primitives.DownlinkFrequency.Type
    object DrMax extends Subtype[Int]
    type DrMax = zio.aws.iotwireless.model.primitives.DrMax.Type
    object DrMaxBox extends Subtype[Int]
    type DrMaxBox = zio.aws.iotwireless.model.primitives.DrMaxBox.Type
    object DrMin extends Subtype[Int]
    type DrMin = zio.aws.iotwireless.model.primitives.DrMin.Type
    object DrMinBox extends Subtype[Int]
    type DrMinBox = zio.aws.iotwireless.model.primitives.DrMinBox.Type
    object EARFCN extends Subtype[Int]
    type EARFCN = zio.aws.iotwireless.model.primitives.EARFCN.Type
    object EndPoint extends Subtype[String]
    type EndPoint = zio.aws.iotwireless.model.primitives.EndPoint.Type
    object EutranCid extends Subtype[Int]
    type EutranCid = zio.aws.iotwireless.model.primitives.EutranCid.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.iotwireless.model.primitives.Expression.Type
    object FCntStart extends Subtype[Int]
    type FCntStart = zio.aws.iotwireless.model.primitives.FCntStart.Type
    object FNwkSIntKey extends Subtype[String]
    type FNwkSIntKey = zio.aws.iotwireless.model.primitives.FNwkSIntKey.Type
    object FPort extends Subtype[Int]
    type FPort = zio.aws.iotwireless.model.primitives.FPort.Type
    object FactorySupport extends Subtype[Boolean]
    type FactorySupport =
      zio.aws.iotwireless.model.primitives.FactorySupport.Type
    object Fingerprint extends Subtype[String]
    type Fingerprint = zio.aws.iotwireless.model.primitives.Fingerprint.Type
    object FirmwareUpdateImage extends Subtype[String]
    type FirmwareUpdateImage =
      zio.aws.iotwireless.model.primitives.FirmwareUpdateImage.Type
    object FirmwareUpdateRole extends Subtype[String]
    type FirmwareUpdateRole =
      zio.aws.iotwireless.model.primitives.FirmwareUpdateRole.Type
    object FragmentIntervalMS extends Subtype[Int]
    type FragmentIntervalMS =
      zio.aws.iotwireless.model.primitives.FragmentIntervalMS.Type
    object FragmentSizeBytes extends Subtype[Int]
    type FragmentSizeBytes =
      zio.aws.iotwireless.model.primitives.FragmentSizeBytes.Type
    object FuotaTaskArn extends Subtype[String]
    type FuotaTaskArn = zio.aws.iotwireless.model.primitives.FuotaTaskArn.Type
    object FuotaTaskId extends Subtype[String]
    type FuotaTaskId = zio.aws.iotwireless.model.primitives.FuotaTaskId.Type
    object FuotaTaskName extends Subtype[String]
    type FuotaTaskName = zio.aws.iotwireless.model.primitives.FuotaTaskName.Type
    object GPST extends Subtype[Float]
    type GPST = zio.aws.iotwireless.model.primitives.GPST.Type
    object GatewayEui extends Subtype[String]
    type GatewayEui = zio.aws.iotwireless.model.primitives.GatewayEui.Type
    object GatewayMaxEirp extends Subtype[Float]
    type GatewayMaxEirp =
      zio.aws.iotwireless.model.primitives.GatewayMaxEirp.Type
    object GenAppKey extends Subtype[String]
    type GenAppKey = zio.aws.iotwireless.model.primitives.GenAppKey.Type
    object GeoJsonPayload extends Subtype[Chunk[Byte]]
    type GeoJsonPayload =
      zio.aws.iotwireless.model.primitives.GeoJsonPayload.Type
    object GeranCid extends Subtype[Int]
    type GeranCid = zio.aws.iotwireless.model.primitives.GeranCid.Type
    object GnssNav extends Subtype[String]
    type GnssNav = zio.aws.iotwireless.model.primitives.GnssNav.Type
    object GsmTimingAdvance extends Subtype[Int]
    type GsmTimingAdvance =
      zio.aws.iotwireless.model.primitives.GsmTimingAdvance.Type
    object HrAllowed extends Subtype[Boolean]
    type HrAllowed = zio.aws.iotwireless.model.primitives.HrAllowed.Type
    object IPAddress extends Subtype[String]
    type IPAddress = zio.aws.iotwireless.model.primitives.IPAddress.Type
    object ISODateTimeString extends Subtype[String]
    type ISODateTimeString =
      zio.aws.iotwireless.model.primitives.ISODateTimeString.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.iotwireless.model.primitives.Identifier.Type
    object ImportTaskArn extends Subtype[String]
    type ImportTaskArn = zio.aws.iotwireless.model.primitives.ImportTaskArn.Type
    object ImportTaskId extends Subtype[String]
    type ImportTaskId = zio.aws.iotwireless.model.primitives.ImportTaskId.Type
    object ImportedWirelessDeviceCount extends Subtype[Long]
    type ImportedWirelessDeviceCount =
      zio.aws.iotwireless.model.primitives.ImportedWirelessDeviceCount.Type
    type Integer = Int
    object IotCertificateId extends Subtype[String]
    type IotCertificateId =
      zio.aws.iotwireless.model.primitives.IotCertificateId.Type
    object JoinEui extends Subtype[String]
    type JoinEui = zio.aws.iotwireless.model.primitives.JoinEui.Type
    object LAC extends Subtype[Int]
    type LAC = zio.aws.iotwireless.model.primitives.LAC.Type
    object LastUpdateTime extends Subtype[Instant]
    type LastUpdateTime =
      zio.aws.iotwireless.model.primitives.LastUpdateTime.Type
    object LteTimingAdvance extends Subtype[Int]
    type LteTimingAdvance =
      zio.aws.iotwireless.model.primitives.LteTimingAdvance.Type
    object MCC extends Subtype[Int]
    type MCC = zio.aws.iotwireless.model.primitives.MCC.Type
    object MNC extends Subtype[Int]
    type MNC = zio.aws.iotwireless.model.primitives.MNC.Type
    object MacAddress extends Subtype[String]
    type MacAddress = zio.aws.iotwireless.model.primitives.MacAddress.Type
    object MacVersion extends Subtype[String]
    type MacVersion = zio.aws.iotwireless.model.primitives.MacVersion.Type
    object MaxAllowedSignature extends Subtype[Int]
    type MaxAllowedSignature =
      zio.aws.iotwireless.model.primitives.MaxAllowedSignature.Type
    object MaxDutyCycle extends Subtype[Int]
    type MaxDutyCycle = zio.aws.iotwireless.model.primitives.MaxDutyCycle.Type
    object MaxEirp extends Subtype[Int]
    type MaxEirp = zio.aws.iotwireless.model.primitives.MaxEirp.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotwireless.model.primitives.MaxResults.Type
    object McGroupId extends Subtype[Int]
    type McGroupId = zio.aws.iotwireless.model.primitives.McGroupId.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.iotwireless.model.primitives.MessageId.Type
    object MinGwDiversity extends Subtype[Int]
    type MinGwDiversity =
      zio.aws.iotwireless.model.primitives.MinGwDiversity.Type
    object Model extends Subtype[String]
    type Model = zio.aws.iotwireless.model.primitives.Model.Type
    object MulticastDeviceStatus extends Subtype[String]
    type MulticastDeviceStatus =
      zio.aws.iotwireless.model.primitives.MulticastDeviceStatus.Type
    object MulticastGroupArn extends Subtype[String]
    type MulticastGroupArn =
      zio.aws.iotwireless.model.primitives.MulticastGroupArn.Type
    object MulticastGroupId extends Subtype[String]
    type MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId.Type
    object MulticastGroupMessageId extends Subtype[String]
    type MulticastGroupMessageId =
      zio.aws.iotwireless.model.primitives.MulticastGroupMessageId.Type
    object MulticastGroupName extends Subtype[String]
    type MulticastGroupName =
      zio.aws.iotwireless.model.primitives.MulticastGroupName.Type
    object MulticastGroupStatus extends Subtype[String]
    type MulticastGroupStatus =
      zio.aws.iotwireless.model.primitives.MulticastGroupStatus.Type
    object NRCapable extends Subtype[Boolean]
    type NRCapable = zio.aws.iotwireless.model.primitives.NRCapable.Type
    object NetId extends Subtype[String]
    type NetId = zio.aws.iotwireless.model.primitives.NetId.Type
    object NetworkAnalyzerConfigurationArn extends Subtype[String]
    type NetworkAnalyzerConfigurationArn =
      zio.aws.iotwireless.model.primitives.NetworkAnalyzerConfigurationArn.Type
    object NetworkAnalyzerConfigurationName extends Subtype[String]
    type NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives.NetworkAnalyzerConfigurationName.Type
    object NetworkId extends Subtype[Int]
    type NetworkId = zio.aws.iotwireless.model.primitives.NetworkId.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotwireless.model.primitives.NextToken.Type
    object NumberOfDevicesInGroup extends Subtype[Int]
    type NumberOfDevicesInGroup =
      zio.aws.iotwireless.model.primitives.NumberOfDevicesInGroup.Type
    object NumberOfDevicesRequested extends Subtype[Int]
    type NumberOfDevicesRequested =
      zio.aws.iotwireless.model.primitives.NumberOfDevicesRequested.Type
    object NwkGeoLoc extends Subtype[Boolean]
    type NwkGeoLoc = zio.aws.iotwireless.model.primitives.NwkGeoLoc.Type
    object NwkKey extends Subtype[String]
    type NwkKey = zio.aws.iotwireless.model.primitives.NwkKey.Type
    object NwkSEncKey extends Subtype[String]
    type NwkSEncKey = zio.aws.iotwireless.model.primitives.NwkSEncKey.Type
    object NwkSKey extends Subtype[String]
    type NwkSKey = zio.aws.iotwireless.model.primitives.NwkSKey.Type
    object OnboardStatusReason extends Subtype[String]
    type OnboardStatusReason =
      zio.aws.iotwireless.model.primitives.OnboardStatusReason.Type
    object PCI extends Subtype[Int]
    type PCI = zio.aws.iotwireless.model.primitives.PCI.Type
    object PSC extends Subtype[Int]
    type PSC = zio.aws.iotwireless.model.primitives.PSC.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.iotwireless.model.primitives.PackageVersion.Type
    object PartnerAccountArn extends Subtype[String]
    type PartnerAccountArn =
      zio.aws.iotwireless.model.primitives.PartnerAccountArn.Type
    object PartnerAccountId extends Subtype[String]
    type PartnerAccountId =
      zio.aws.iotwireless.model.primitives.PartnerAccountId.Type
    object PathLoss extends Subtype[Int]
    type PathLoss = zio.aws.iotwireless.model.primitives.PathLoss.Type
    object PayloadData extends Subtype[String]
    type PayloadData = zio.aws.iotwireless.model.primitives.PayloadData.Type
    object PilotPower extends Subtype[Int]
    type PilotPower = zio.aws.iotwireless.model.primitives.PilotPower.Type
    object PingSlotDr extends Subtype[Int]
    type PingSlotDr = zio.aws.iotwireless.model.primitives.PingSlotDr.Type
    object PingSlotFreq extends Subtype[Int]
    type PingSlotFreq = zio.aws.iotwireless.model.primitives.PingSlotFreq.Type
    object PingSlotPeriod extends Subtype[Int]
    type PingSlotPeriod =
      zio.aws.iotwireless.model.primitives.PingSlotPeriod.Type
    object PnOffset extends Subtype[Int]
    type PnOffset = zio.aws.iotwireless.model.primitives.PnOffset.Type
    object PositionResourceIdentifier extends Subtype[String]
    type PositionResourceIdentifier =
      zio.aws.iotwireless.model.primitives.PositionResourceIdentifier.Type
    object PrAllowed extends Subtype[Boolean]
    type PrAllowed = zio.aws.iotwireless.model.primitives.PrAllowed.Type
    object PresetFreq extends Subtype[Int]
    type PresetFreq = zio.aws.iotwireless.model.primitives.PresetFreq.Type
    object QualificationStatus extends Subtype[Boolean]
    type QualificationStatus =
      zio.aws.iotwireless.model.primitives.QualificationStatus.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.iotwireless.model.primitives.QueryString.Type
    object RSCP extends Subtype[Int]
    type RSCP = zio.aws.iotwireless.model.primitives.RSCP.Type
    object RSRP extends Subtype[Int]
    type RSRP = zio.aws.iotwireless.model.primitives.RSRP.Type
    object RSRQ extends Subtype[Float]
    type RSRQ = zio.aws.iotwireless.model.primitives.RSRQ.Type
    object RSS extends Subtype[Int]
    type RSS = zio.aws.iotwireless.model.primitives.RSS.Type
    object RaAllowed extends Subtype[Boolean]
    type RaAllowed = zio.aws.iotwireless.model.primitives.RaAllowed.Type
    object RedundancyPercent extends Subtype[Int]
    type RedundancyPercent =
      zio.aws.iotwireless.model.primitives.RedundancyPercent.Type
    object RegParamsRevision extends Subtype[String]
    type RegParamsRevision =
      zio.aws.iotwireless.model.primitives.RegParamsRevision.Type
    object RegistrationZone extends Subtype[Int]
    type RegistrationZone =
      zio.aws.iotwireless.model.primitives.RegistrationZone.Type
    object ReportDevStatusBattery extends Subtype[Boolean]
    type ReportDevStatusBattery =
      zio.aws.iotwireless.model.primitives.ReportDevStatusBattery.Type
    object ReportDevStatusMargin extends Subtype[Boolean]
    type ReportDevStatusMargin =
      zio.aws.iotwireless.model.primitives.ReportDevStatusMargin.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.iotwireless.model.primitives.ResourceIdentifier.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.iotwireless.model.primitives.ResourceType.Type
    object Result extends Subtype[String]
    type Result = zio.aws.iotwireless.model.primitives.Result.Type
    object RfRegion extends Subtype[String]
    type RfRegion = zio.aws.iotwireless.model.primitives.RfRegion.Type
    object Role extends Subtype[String]
    type Role = zio.aws.iotwireless.model.primitives.Role.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iotwireless.model.primitives.RoleArn.Type
    object RxDataRate2 extends Subtype[Int]
    type RxDataRate2 = zio.aws.iotwireless.model.primitives.RxDataRate2.Type
    object RxDelay1 extends Subtype[Int]
    type RxDelay1 = zio.aws.iotwireless.model.primitives.RxDelay1.Type
    object RxDrOffset1 extends Subtype[Int]
    type RxDrOffset1 = zio.aws.iotwireless.model.primitives.RxDrOffset1.Type
    object RxFreq2 extends Subtype[Int]
    type RxFreq2 = zio.aws.iotwireless.model.primitives.RxFreq2.Type
    object RxLevel extends Subtype[Int]
    type RxLevel = zio.aws.iotwireless.model.primitives.RxLevel.Type
    object SNwkSIntKey extends Subtype[String]
    type SNwkSIntKey = zio.aws.iotwireless.model.primitives.SNwkSIntKey.Type
    object Seq extends Subtype[Int]
    type Seq = zio.aws.iotwireless.model.primitives.Seq.Type
    object ServiceProfileArn extends Subtype[String]
    type ServiceProfileArn =
      zio.aws.iotwireless.model.primitives.ServiceProfileArn.Type
    object ServiceProfileId extends Subtype[String]
    type ServiceProfileId =
      zio.aws.iotwireless.model.primitives.ServiceProfileId.Type
    object ServiceProfileName extends Subtype[String]
    type ServiceProfileName =
      zio.aws.iotwireless.model.primitives.ServiceProfileName.Type
    object SessionStartTimeTimestamp extends Subtype[Instant]
    type SessionStartTimeTimestamp =
      zio.aws.iotwireless.model.primitives.SessionStartTimeTimestamp.Type
    object SessionTimeout extends Subtype[Int]
    type SessionTimeout =
      zio.aws.iotwireless.model.primitives.SessionTimeout.Type
    object SidewalkId extends Subtype[String]
    type SidewalkId = zio.aws.iotwireless.model.primitives.SidewalkId.Type
    object SidewalkManufacturingSn extends Subtype[String]
    type SidewalkManufacturingSn =
      zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.iotwireless.model.primitives.StartTime.Type
    object Station extends Subtype[String]
    type Station = zio.aws.iotwireless.model.primitives.Station.Type
    object StatusReason extends Subtype[String]
    type StatusReason = zio.aws.iotwireless.model.primitives.StatusReason.Type
    object SubBand extends Subtype[Int]
    type SubBand = zio.aws.iotwireless.model.primitives.SubBand.Type
    object Supports32BitFCnt extends Subtype[Boolean]
    type Supports32BitFCnt =
      zio.aws.iotwireless.model.primitives.Supports32BitFCnt.Type
    object SupportsClassB extends Subtype[Boolean]
    type SupportsClassB =
      zio.aws.iotwireless.model.primitives.SupportsClassB.Type
    object SupportsClassC extends Subtype[Boolean]
    type SupportsClassC =
      zio.aws.iotwireless.model.primitives.SupportsClassC.Type
    object SupportsJoin extends Subtype[Boolean]
    type SupportsJoin = zio.aws.iotwireless.model.primitives.SupportsJoin.Type
    object SystemId extends Subtype[Int]
    type SystemId = zio.aws.iotwireless.model.primitives.SystemId.Type
    object TAC extends Subtype[Int]
    type TAC = zio.aws.iotwireless.model.primitives.TAC.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotwireless.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotwireless.model.primitives.TagValue.Type
    object TargetPer extends Subtype[Int]
    type TargetPer = zio.aws.iotwireless.model.primitives.TargetPer.Type
    object TdscdmaTimingAdvance extends Subtype[Int]
    type TdscdmaTimingAdvance =
      zio.aws.iotwireless.model.primitives.TdscdmaTimingAdvance.Type
    object ThingArn extends Subtype[String]
    type ThingArn = zio.aws.iotwireless.model.primitives.ThingArn.Type
    object ThingName extends Subtype[String]
    type ThingName = zio.aws.iotwireless.model.primitives.ThingName.Type
    object TransmissionInterval extends Subtype[Int]
    type TransmissionInterval =
      zio.aws.iotwireless.model.primitives.TransmissionInterval.Type
    object TransmitMode extends Subtype[Int]
    type TransmitMode = zio.aws.iotwireless.model.primitives.TransmitMode.Type
    object UARFCN extends Subtype[Int]
    type UARFCN = zio.aws.iotwireless.model.primitives.UARFCN.Type
    object UARFCNDL extends Subtype[Int]
    type UARFCNDL = zio.aws.iotwireless.model.primitives.UARFCNDL.Type
    object UlBucketSize extends Subtype[Int]
    type UlBucketSize = zio.aws.iotwireless.model.primitives.UlBucketSize.Type
    object UlRate extends Subtype[Int]
    type UlRate = zio.aws.iotwireless.model.primitives.UlRate.Type
    object UlRatePolicy extends Subtype[String]
    type UlRatePolicy = zio.aws.iotwireless.model.primitives.UlRatePolicy.Type
    object UpdateDataSource extends Subtype[String]
    type UpdateDataSource =
      zio.aws.iotwireless.model.primitives.UpdateDataSource.Type
    object UpdateSignature extends Subtype[String]
    type UpdateSignature =
      zio.aws.iotwireless.model.primitives.UpdateSignature.Type
    object Use2DSolver extends Subtype[Boolean]
    type Use2DSolver = zio.aws.iotwireless.model.primitives.Use2DSolver.Type
    object UtranCid extends Subtype[Int]
    type UtranCid = zio.aws.iotwireless.model.primitives.UtranCid.Type
    object WirelessDeviceArn extends Subtype[String]
    type WirelessDeviceArn =
      zio.aws.iotwireless.model.primitives.WirelessDeviceArn.Type
    object WirelessDeviceId extends Subtype[String]
    type WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId.Type
    object WirelessDeviceName extends Subtype[String]
    type WirelessDeviceName =
      zio.aws.iotwireless.model.primitives.WirelessDeviceName.Type
    object WirelessGatewayArn extends Subtype[String]
    type WirelessGatewayArn =
      zio.aws.iotwireless.model.primitives.WirelessGatewayArn.Type
    object WirelessGatewayId extends Subtype[String]
    type WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId.Type
    object WirelessGatewayName extends Subtype[String]
    type WirelessGatewayName =
      zio.aws.iotwireless.model.primitives.WirelessGatewayName.Type
    object WirelessGatewayTaskDefinitionArn extends Subtype[String]
    type WirelessGatewayTaskDefinitionArn =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionArn.Type
    object WirelessGatewayTaskDefinitionId extends Subtype[String]
    type WirelessGatewayTaskDefinitionId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionId.Type
    object WirelessGatewayTaskName extends Subtype[String]
    type WirelessGatewayTaskName =
      zio.aws.iotwireless.model.primitives.WirelessGatewayTaskName.Type
  }
  type Applications = List[zio.aws.iotwireless.model.ApplicationConfig]
  type AssistPosition = List[Coordinate]
  type BeaconingFrequencies = List[BeaconingFrequency]
  type CdmaList = List[zio.aws.iotwireless.model.CdmaObj]
  type CdmaNmrList = List[zio.aws.iotwireless.model.CdmaNmrObj]
  type DakCertificateMetadataList =
    List[zio.aws.iotwireless.model.DakCertificateMetadata]
  type DestinationList = List[zio.aws.iotwireless.model.Destinations]
  type DeviceCertificateList = List[zio.aws.iotwireless.model.CertificateList]
  type DeviceCreationFileList = List[DeviceCreationFile]
  type DeviceProfileList = List[zio.aws.iotwireless.model.DeviceProfile]
  type DownlinkQueueMessagesList =
    List[zio.aws.iotwireless.model.DownlinkQueueMessage]
  type EventConfigurationsList =
    List[zio.aws.iotwireless.model.EventConfigurationItem]
  type FactoryPresetFreqsList = List[PresetFreq]
  type FuotaTaskList = List[zio.aws.iotwireless.model.FuotaTask]
  type GatewayList = List[zio.aws.iotwireless.model.GatewayListItem]
  type GsmList = List[zio.aws.iotwireless.model.GsmObj]
  type GsmNmrList = List[zio.aws.iotwireless.model.GsmNmrObj]
  type ImportedWirelessDeviceList =
    List[zio.aws.iotwireless.model.ImportedWirelessDevice]
  type JoinEuiFilters = List[Iterable[JoinEui]]
  type JoinEuiRange = List[JoinEui]
  type LoRaWANGatewayMetadataList =
    List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata]
  type LteList = List[zio.aws.iotwireless.model.LteObj]
  type LteNmrList = List[zio.aws.iotwireless.model.LteNmrObj]
  type MulticastGroupList = List[zio.aws.iotwireless.model.MulticastGroup]
  type MulticastGroupListByFuotaTask =
    List[zio.aws.iotwireless.model.MulticastGroupByFuotaTask]
  type NetIdFilters = List[NetId]
  type NetworkAnalyzerConfigurationList =
    List[zio.aws.iotwireless.model.NetworkAnalyzerConfigurations]
  type NetworkAnalyzerMulticastGroupList = List[MulticastGroupId]
  type PrivateKeysList = List[zio.aws.iotwireless.model.CertificateList]
  type ServiceProfileList = List[zio.aws.iotwireless.model.ServiceProfile]
  type SidewalkAccountList =
    List[zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint]
  type SubBands = List[SubBand]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.iotwireless.model.Tag]
  type TdscdmaList = List[zio.aws.iotwireless.model.TdscdmaObj]
  type TdscdmaNmrList = List[zio.aws.iotwireless.model.TdscdmaNmrObj]
  type WcdmaList = List[zio.aws.iotwireless.model.WcdmaObj]
  type WcdmaNmrList = List[zio.aws.iotwireless.model.WcdmaNmrObj]
  type WiFiAccessPoints = List[zio.aws.iotwireless.model.WiFiAccessPoint]
  type WirelessDeviceEventLogOptionList =
    List[zio.aws.iotwireless.model.WirelessDeviceEventLogOption]
  type WirelessDeviceImportTaskList =
    List[zio.aws.iotwireless.model.WirelessDeviceImportTask]
  type WirelessDeviceList = List[WirelessDeviceId]
  type WirelessDeviceLogOptionList =
    List[zio.aws.iotwireless.model.WirelessDeviceLogOption]
  type WirelessDeviceStatisticsList =
    List[zio.aws.iotwireless.model.WirelessDeviceStatistics]
  type WirelessGatewayEventLogOptionList =
    List[zio.aws.iotwireless.model.WirelessGatewayEventLogOption]
  type WirelessGatewayList = List[WirelessGatewayId]
  type WirelessGatewayLogOptionList =
    List[zio.aws.iotwireless.model.WirelessGatewayLogOption]
  type WirelessGatewayStatisticsList =
    List[zio.aws.iotwireless.model.WirelessGatewayStatistics]
  type WirelessGatewayTaskDefinitionList =
    List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry]
}
