package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WirelessGatewayLogOption(
    `type`: zio.aws.iotwireless.model.WirelessGatewayType,
    logLevel: zio.aws.iotwireless.model.LogLevel,
    events: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayEventLogOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption = {
    import WirelessGatewayLogOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption
      .builder()
      .`type`(`type`.unwrap)
      .logLevel(logLevel.unwrap)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly =
    zio.aws.iotwireless.model.WirelessGatewayLogOption.wrap(buildAwsValue())
}
object WirelessGatewayLogOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessGatewayLogOption =
      zio.aws.iotwireless.model.WirelessGatewayLogOption(
        `type`,
        logLevel,
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.iotwireless.model.WirelessGatewayType
    def logLevel: zio.aws.iotwireless.model.LogLevel
    def events: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly]
    ]
    def getType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessGatewayType] =
      ZIO.succeed(`type`)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iotwireless.model.LogLevel] =
      ZIO.succeed(logLevel)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption
  ) extends zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly {
    override val `type`: zio.aws.iotwireless.model.WirelessGatewayType =
      zio.aws.iotwireless.model.WirelessGatewayType.wrap(impl.`type`())
    override val logLevel: zio.aws.iotwireless.model.LogLevel =
      zio.aws.iotwireless.model.LogLevel.wrap(impl.logLevel())
    override val events: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayEventLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption
  ): zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly = new Wrapper(
    impl
  )
}
