package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  MulticastDeviceStatus,
  WirelessDeviceName,
  ISODateTimeString,
  McGroupId,
  WirelessDeviceId,
  WirelessDeviceArn,
  DestinationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WirelessDeviceStatistics(
    arn: Optional[WirelessDeviceArn] = Optional.Absent,
    id: Optional[WirelessDeviceId] = Optional.Absent,
    `type`: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent,
    name: Optional[WirelessDeviceName] = Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent,
    lastUplinkReceivedAt: Optional[ISODateTimeString] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANListDevice] =
      Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkListDevice] =
      Optional.Absent,
    fuotaDeviceStatus: Optional[zio.aws.iotwireless.model.FuotaDeviceStatus] =
      Optional.Absent,
    multicastDeviceStatus: Optional[MulticastDeviceStatus] = Optional.Absent,
    mcGroupId: Optional[McGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics = {
    import WirelessDeviceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
      .builder()
      .optionallyWith(
        arn.map(value => WirelessDeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(fuotaDeviceStatus.map(value => value.unwrap))(
        _.fuotaDeviceStatus
      )
      .optionallyWith(
        multicastDeviceStatus.map(value =>
          MulticastDeviceStatus.unwrap(value): java.lang.String
        )
      )(_.multicastDeviceStatus)
      .optionallyWith(mcGroupId.map(value => McGroupId.unwrap(value): Integer))(
        _.mcGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly =
    zio.aws.iotwireless.model.WirelessDeviceStatistics.wrap(buildAwsValue())
}
object WirelessDeviceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessDeviceStatistics =
      zio.aws.iotwireless.model.WirelessDeviceStatistics(
        arn.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        destinationName.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable),
        fuotaDeviceStatus.map(value => value),
        multicastDeviceStatus.map(value => value),
        mcGroupId.map(value => value)
      )
    def arn: Optional[WirelessDeviceArn]
    def id: Optional[WirelessDeviceId]
    def `type`: Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def name: Optional[WirelessDeviceName]
    def destinationName: Optional[DestinationName]
    def lastUplinkReceivedAt: Optional[ISODateTimeString]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly]
    def sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly]
    def fuotaDeviceStatus: Optional[zio.aws.iotwireless.model.FuotaDeviceStatus]
    def multicastDeviceStatus: Optional[MulticastDeviceStatus]
    def mcGroupId: Optional[McGroupId]
    def getArn: ZIO[Any, AwsError, WirelessDeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getFuotaDeviceStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.FuotaDeviceStatus] =
      AwsError.unwrapOptionField("fuotaDeviceStatus", fuotaDeviceStatus)
    def getMulticastDeviceStatus: ZIO[Any, AwsError, MulticastDeviceStatus] =
      AwsError.unwrapOptionField("multicastDeviceStatus", multicastDeviceStatus)
    def getMcGroupId: ZIO[Any, AwsError, McGroupId] =
      AwsError.unwrapOptionField("mcGroupId", mcGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ) extends zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly {
    override val arn: Optional[WirelessDeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceArn(value)
      )
    override val id: Optional[WirelessDeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
    override val `type`
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val name: Optional[WirelessDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val lastUplinkReceivedAt: Optional[ISODateTimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUplinkReceivedAt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
        )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANListDevice.wrap(value))
    override val sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalk())
        .map(value => zio.aws.iotwireless.model.SidewalkListDevice.wrap(value))
    override val fuotaDeviceStatus
        : Optional[zio.aws.iotwireless.model.FuotaDeviceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fuotaDeviceStatus())
        .map(value => zio.aws.iotwireless.model.FuotaDeviceStatus.wrap(value))
    override val multicastDeviceStatus: Optional[MulticastDeviceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multicastDeviceStatus())
        .map(value =>
          zio.aws.iotwireless.model.primitives.MulticastDeviceStatus(value)
        )
    override val mcGroupId: Optional[McGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.mcGroupId())
      .map(value => zio.aws.iotwireless.model.primitives.McGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ): zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly = new Wrapper(
    impl
  )
}
