package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessDeviceSidewalkStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus
}
object WirelessDeviceSidewalkStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus
  ): zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.REGISTERED =>
      val r = REGISTERED
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.ACTIVATED =>
      val r = ACTIVATED
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONED
      extends zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.PROVISIONED
  }
  case object REGISTERED
      extends zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.REGISTERED
  }
  case object ACTIVATED
      extends zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.ACTIVATED
  }
  case object UNKNOWN
      extends zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceSidewalkStatus.UNKNOWN
  }
}
