package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  UtranCid,
  LAC,
  PathLoss,
  MCC,
  RSCP,
  MNC
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WcdmaObj(
    mcc: MCC,
    mnc: MNC,
    lac: Optional[LAC] = Optional.Absent,
    utranCid: UtranCid,
    wcdmaLocalId: Optional[zio.aws.iotwireless.model.WcdmaLocalId] =
      Optional.Absent,
    rscp: Optional[RSCP] = Optional.Absent,
    pathLoss: Optional[PathLoss] = Optional.Absent,
    wcdmaNmr: Optional[Iterable[zio.aws.iotwireless.model.WcdmaNmrObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WcdmaObj = {
    import WcdmaObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WcdmaObj
      .builder()
      .mcc(MCC.unwrap(mcc): Integer)
      .mnc(MNC.unwrap(mnc): Integer)
      .optionallyWith(lac.map(value => LAC.unwrap(value): Integer))(_.lac)
      .utranCid(UtranCid.unwrap(utranCid): Integer)
      .optionallyWith(wcdmaLocalId.map(value => value.buildAwsValue()))(
        _.wcdmaLocalId
      )
      .optionallyWith(rscp.map(value => RSCP.unwrap(value): Integer))(_.rscp)
      .optionallyWith(pathLoss.map(value => PathLoss.unwrap(value): Integer))(
        _.pathLoss
      )
      .optionallyWith(
        wcdmaNmr.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wcdmaNmr)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WcdmaObj.ReadOnly =
    zio.aws.iotwireless.model.WcdmaObj.wrap(buildAwsValue())
}
object WcdmaObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WcdmaObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WcdmaObj =
      zio.aws.iotwireless.model.WcdmaObj(
        mcc,
        mnc,
        lac.map(value => value),
        utranCid,
        wcdmaLocalId.map(value => value.asEditable),
        rscp.map(value => value),
        pathLoss.map(value => value),
        wcdmaNmr.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mcc: MCC
    def mnc: MNC
    def lac: Optional[LAC]
    def utranCid: UtranCid
    def wcdmaLocalId: Optional[zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly]
    def rscp: Optional[RSCP]
    def pathLoss: Optional[PathLoss]
    def wcdmaNmr: Optional[List[zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly]]
    def getMcc: ZIO[Any, Nothing, MCC] = ZIO.succeed(mcc)
    def getMnc: ZIO[Any, Nothing, MNC] = ZIO.succeed(mnc)
    def getLac: ZIO[Any, AwsError, LAC] = AwsError.unwrapOptionField("lac", lac)
    def getUtranCid: ZIO[Any, Nothing, UtranCid] = ZIO.succeed(utranCid)
    def getWcdmaLocalId
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly] =
      AwsError.unwrapOptionField("wcdmaLocalId", wcdmaLocalId)
    def getRscp: ZIO[Any, AwsError, RSCP] =
      AwsError.unwrapOptionField("rscp", rscp)
    def getPathLoss: ZIO[Any, AwsError, PathLoss] =
      AwsError.unwrapOptionField("pathLoss", pathLoss)
    def getWcdmaNmr: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly
    ]] = AwsError.unwrapOptionField("wcdmaNmr", wcdmaNmr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaObj
  ) extends zio.aws.iotwireless.model.WcdmaObj.ReadOnly {
    override val mcc: MCC = zio.aws.iotwireless.model.primitives.MCC(impl.mcc())
    override val mnc: MNC = zio.aws.iotwireless.model.primitives.MNC(impl.mnc())
    override val lac: Optional[LAC] = zio.aws.core.internal
      .optionalFromNullable(impl.lac())
      .map(value => zio.aws.iotwireless.model.primitives.LAC(value))
    override val utranCid: UtranCid =
      zio.aws.iotwireless.model.primitives.UtranCid(impl.utranCid())
    override val wcdmaLocalId
        : Optional[zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wcdmaLocalId())
        .map(value => zio.aws.iotwireless.model.WcdmaLocalId.wrap(value))
    override val rscp: Optional[RSCP] = zio.aws.core.internal
      .optionalFromNullable(impl.rscp())
      .map(value => zio.aws.iotwireless.model.primitives.RSCP(value))
    override val pathLoss: Optional[PathLoss] = zio.aws.core.internal
      .optionalFromNullable(impl.pathLoss())
      .map(value => zio.aws.iotwireless.model.primitives.PathLoss(value))
    override val wcdmaNmr
        : Optional[List[zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wcdmaNmr())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.WcdmaNmrObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaObj
  ): zio.aws.iotwireless.model.WcdmaObj.ReadOnly = new Wrapper(impl)
}
