package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  UtranCid,
  PathLoss,
  PSC,
  RSCP,
  UARFCNDL
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WcdmaNmrObj(
    uarfcndl: UARFCNDL,
    psc: PSC,
    utranCid: UtranCid,
    rscp: Optional[RSCP] = Optional.Absent,
    pathLoss: Optional[PathLoss] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj = {
    import WcdmaNmrObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj
      .builder()
      .uarfcndl(UARFCNDL.unwrap(uarfcndl): Integer)
      .psc(PSC.unwrap(psc): Integer)
      .utranCid(UtranCid.unwrap(utranCid): Integer)
      .optionallyWith(rscp.map(value => RSCP.unwrap(value): Integer))(_.rscp)
      .optionallyWith(pathLoss.map(value => PathLoss.unwrap(value): Integer))(
        _.pathLoss
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly =
    zio.aws.iotwireless.model.WcdmaNmrObj.wrap(buildAwsValue())
}
object WcdmaNmrObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WcdmaNmrObj =
      zio.aws.iotwireless.model.WcdmaNmrObj(
        uarfcndl,
        psc,
        utranCid,
        rscp.map(value => value),
        pathLoss.map(value => value)
      )
    def uarfcndl: UARFCNDL
    def psc: PSC
    def utranCid: UtranCid
    def rscp: Optional[RSCP]
    def pathLoss: Optional[PathLoss]
    def getUarfcndl: ZIO[Any, Nothing, UARFCNDL] = ZIO.succeed(uarfcndl)
    def getPsc: ZIO[Any, Nothing, PSC] = ZIO.succeed(psc)
    def getUtranCid: ZIO[Any, Nothing, UtranCid] = ZIO.succeed(utranCid)
    def getRscp: ZIO[Any, AwsError, RSCP] =
      AwsError.unwrapOptionField("rscp", rscp)
    def getPathLoss: ZIO[Any, AwsError, PathLoss] =
      AwsError.unwrapOptionField("pathLoss", pathLoss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj
  ) extends zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly {
    override val uarfcndl: UARFCNDL =
      zio.aws.iotwireless.model.primitives.UARFCNDL(impl.uarfcndl())
    override val psc: PSC = zio.aws.iotwireless.model.primitives.PSC(impl.psc())
    override val utranCid: UtranCid =
      zio.aws.iotwireless.model.primitives.UtranCid(impl.utranCid())
    override val rscp: Optional[RSCP] = zio.aws.core.internal
      .optionalFromNullable(impl.rscp())
      .map(value => zio.aws.iotwireless.model.primitives.RSCP(value))
    override val pathLoss: Optional[PathLoss] = zio.aws.core.internal
      .optionalFromNullable(impl.pathLoss())
      .map(value => zio.aws.iotwireless.model.primitives.PathLoss(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaNmrObj
  ): zio.aws.iotwireless.model.WcdmaNmrObj.ReadOnly = new Wrapper(impl)
}
