package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{PSC, UARFCNDL}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WcdmaLocalId(uarfcndl: UARFCNDL, psc: PSC) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId = {
    import WcdmaLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId
      .builder()
      .uarfcndl(UARFCNDL.unwrap(uarfcndl): Integer)
      .psc(PSC.unwrap(psc): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly =
    zio.aws.iotwireless.model.WcdmaLocalId.wrap(buildAwsValue())
}
object WcdmaLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WcdmaLocalId =
      zio.aws.iotwireless.model.WcdmaLocalId(uarfcndl, psc)
    def uarfcndl: UARFCNDL
    def psc: PSC
    def getUarfcndl: ZIO[Any, Nothing, UARFCNDL] = ZIO.succeed(uarfcndl)
    def getPsc: ZIO[Any, Nothing, PSC] = ZIO.succeed(psc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId
  ) extends zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly {
    override val uarfcndl: UARFCNDL =
      zio.aws.iotwireless.model.primitives.UARFCNDL(impl.uarfcndl())
    override val psc: PSC = zio.aws.iotwireless.model.primitives.PSC(impl.psc())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WcdmaLocalId
  ): zio.aws.iotwireless.model.WcdmaLocalId.ReadOnly = new Wrapper(impl)
}
