package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskDefinitionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWirelessGatewayTaskEntry(
    id: Optional[WirelessGatewayTaskDefinitionId] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry] =
      Optional.Absent,
    arn: Optional[WirelessGatewayTaskDefinitionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry = {
    import UpdateWirelessGatewayTaskEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
      .builder()
      .optionallyWith(
        id.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry
      .wrap(buildAwsValue())
}
object UpdateWirelessGatewayTaskEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry =
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry(
        id.map(value => value),
        loRaWAN.map(value => value.asEditable),
        arn.map(value => value)
      )
    def id: Optional[WirelessGatewayTaskDefinitionId]
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ]
    def arn: Optional[WirelessGatewayTaskDefinitionArn]
    def getId: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField("id", id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ) extends zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly {
    override val id: Optional[WirelessGatewayTaskDefinitionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .WirelessGatewayTaskDefinitionId(value)
        )
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.wrap(value)
      )
    override val arn: Optional[WirelessGatewayTaskDefinitionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .WirelessGatewayTaskDefinitionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ): zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly =
    new Wrapper(impl)
}
