package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLogLevelsByResourceTypesRequest(
    defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      Optional.Absent,
    wirelessDeviceLogOptions: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceLogOption]
    ] = Optional.Absent,
    wirelessGatewayLogOptions: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayLogOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest = {
    import UpdateLogLevelsByResourceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
      .builder()
      .optionallyWith(defaultLogLevel.map(value => value.unwrap))(
        _.defaultLogLevel
      )
      .optionallyWith(
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceLogOptions)
      .optionallyWith(
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayLogOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
      .wrap(buildAwsValue())
}
object UpdateLogLevelsByResourceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest =
      zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest(
        defaultLogLevel.map(value => value),
        wirelessDeviceLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wirelessGatewayLogOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel]
    def wirelessDeviceLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ]
    def wirelessGatewayLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ]
    def getDefaultLogLevel
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("defaultLogLevel", defaultLogLevel)
    def getWirelessDeviceLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessDeviceLogOptions",
      wirelessDeviceLogOptions
    )
    def getWirelessGatewayLogOptions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessGatewayLogOptions",
      wirelessGatewayLogOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ) extends zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly {
    override val defaultLogLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultLogLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
    override val wirelessDeviceLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessDeviceLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceLogOption.wrap(item)
        }.toList
      )
    override val wirelessGatewayLogOptions: Optional[
      List[zio.aws.iotwireless.model.WirelessGatewayLogOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessGatewayLogOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ): zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
