package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  FragmentIntervalMS,
  FirmwareUpdateRole,
  FragmentSizeBytes,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  FuotaTaskId,
  RedundancyPercent
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFuotaTaskRequest(
    id: FuotaTaskId,
    name: Optional[FuotaTaskName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask] =
      Optional.Absent,
    firmwareUpdateImage: Optional[FirmwareUpdateImage] = Optional.Absent,
    firmwareUpdateRole: Optional[FirmwareUpdateRole] = Optional.Absent,
    redundancyPercent: Optional[RedundancyPercent] = Optional.Absent,
    fragmentSizeBytes: Optional[FragmentSizeBytes] = Optional.Absent,
    fragmentIntervalMS: Optional[FragmentIntervalMS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest = {
    import UpdateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        firmwareUpdateImage.map(value =>
          FirmwareUpdateImage.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateImage)
      .optionallyWith(
        firmwareUpdateRole.map(value =>
          FirmwareUpdateRole.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateRole)
      .optionallyWith(
        redundancyPercent.map(value => RedundancyPercent.unwrap(value): Integer)
      )(_.redundancyPercent)
      .optionallyWith(
        fragmentSizeBytes.map(value => FragmentSizeBytes.unwrap(value): Integer)
      )(_.fragmentSizeBytes)
      .optionallyWith(
        fragmentIntervalMS.map(value =>
          FragmentIntervalMS.unwrap(value): Integer
        )
      )(_.fragmentIntervalMS)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateFuotaTaskRequest.wrap(buildAwsValue())
}
object UpdateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateFuotaTaskRequest =
      zio.aws.iotwireless.model.UpdateFuotaTaskRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage.map(value => value),
        firmwareUpdateRole.map(value => value),
        redundancyPercent.map(value => value),
        fragmentSizeBytes.map(value => value),
        fragmentIntervalMS.map(value => value)
      )
    def id: FuotaTaskId
    def name: Optional[FuotaTaskName]
    def description: Optional[Description]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: Optional[FirmwareUpdateImage]
    def firmwareUpdateRole: Optional[FirmwareUpdateRole]
    def redundancyPercent: Optional[RedundancyPercent]
    def fragmentSizeBytes: Optional[FragmentSizeBytes]
    def fragmentIntervalMS: Optional[FragmentIntervalMS]
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, AwsError, FirmwareUpdateImage] =
      AwsError.unwrapOptionField("firmwareUpdateImage", firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, AwsError, FirmwareUpdateRole] =
      AwsError.unwrapOptionField("firmwareUpdateRole", firmwareUpdateRole)
    def getRedundancyPercent: ZIO[Any, AwsError, RedundancyPercent] =
      AwsError.unwrapOptionField("redundancyPercent", redundancyPercent)
    def getFragmentSizeBytes: ZIO[Any, AwsError, FragmentSizeBytes] =
      AwsError.unwrapOptionField("fragmentSizeBytes", fragmentSizeBytes)
    def getFragmentIntervalMS: ZIO[Any, AwsError, FragmentIntervalMS] =
      AwsError.unwrapOptionField("fragmentIntervalMS", fragmentIntervalMS)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val name: Optional[FuotaTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: Optional[FirmwareUpdateImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateImage())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateImage(value)
        )
    override val firmwareUpdateRole: Optional[FirmwareUpdateRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateRole())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateRole(value)
        )
    override val redundancyPercent: Optional[RedundancyPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redundancyPercent())
        .map(value =>
          zio.aws.iotwireless.model.primitives.RedundancyPercent(value)
        )
    override val fragmentSizeBytes: Optional[FragmentSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentSizeBytes())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FragmentSizeBytes(value)
        )
    override val fragmentIntervalMS: Optional[FragmentIntervalMS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentIntervalMS())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FragmentIntervalMS(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ): zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
