package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{CellParams, UARFCN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TdscdmaLocalId(uarfcn: UARFCN, cellParams: CellParams) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TdscdmaLocalId = {
    import TdscdmaLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TdscdmaLocalId
      .builder()
      .uarfcn(UARFCN.unwrap(uarfcn): Integer)
      .cellParams(CellParams.unwrap(cellParams): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly =
    zio.aws.iotwireless.model.TdscdmaLocalId.wrap(buildAwsValue())
}
object TdscdmaLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TdscdmaLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TdscdmaLocalId =
      zio.aws.iotwireless.model.TdscdmaLocalId(uarfcn, cellParams)
    def uarfcn: UARFCN
    def cellParams: CellParams
    def getUarfcn: ZIO[Any, Nothing, UARFCN] = ZIO.succeed(uarfcn)
    def getCellParams: ZIO[Any, Nothing, CellParams] = ZIO.succeed(cellParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaLocalId
  ) extends zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly {
    override val uarfcn: UARFCN =
      zio.aws.iotwireless.model.primitives.UARFCN(impl.uarfcn())
    override val cellParams: CellParams =
      zio.aws.iotwireless.model.primitives.CellParams(impl.cellParams())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaLocalId
  ): zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly = new Wrapper(impl)
}
