package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ImportTaskArn, ImportTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartWirelessDeviceImportTaskResponse(
    id: Optional[ImportTaskId] = Optional.Absent,
    arn: Optional[ImportTaskArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse = {
    import StartWirelessDeviceImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse
      .builder()
      .optionallyWith(
        id.map(value => ImportTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ImportTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse
      .wrap(buildAwsValue())
}
object StartWirelessDeviceImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse =
      zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[ImportTaskId]
    def arn: Optional[ImportTaskArn]
    def getId: ZIO[Any, AwsError, ImportTaskId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ImportTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse
  ) extends zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse.ReadOnly {
    override val id: Optional[ImportTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.ImportTaskId(value))
    override val arn: Optional[ImportTaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.ImportTaskArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskResponse
  ): zio.aws.iotwireless.model.StartWirelessDeviceImportTaskResponse.ReadOnly =
    new Wrapper(impl)
}
