package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DeviceName,
  ClientRequestToken,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartSingleWirelessDeviceImportTaskRequest(
    destinationName: DestinationName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    deviceName: Optional[DeviceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    sidewalk: zio.aws.iotwireless.model.SidewalkSingleStartImportInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest = {
    import StartSingleWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest
      .builder()
      .destinationName(
        DestinationName.unwrap(destinationName): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .sidewalk(sidewalk.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object StartSingleWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest(
        destinationName,
        clientRequestToken.map(value => value),
        deviceName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sidewalk.asEditable
      )
    def destinationName: DestinationName
    def clientRequestToken: Optional[ClientRequestToken]
    def deviceName: Optional[DeviceName]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def sidewalk
        : zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly
    def getDestinationName: ZIO[Any, Nothing, DestinationName] =
      ZIO.succeed(destinationName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSidewalk: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly
    ] = ZIO.succeed(sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest.ReadOnly {
    override val destinationName: DestinationName =
      zio.aws.iotwireless.model.primitives
        .DestinationName(impl.destinationName())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val deviceName: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceName(value))
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val sidewalk
        : zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly =
      zio.aws.iotwireless.model.SidewalkSingleStartImportInfo
        .wrap(impl.sidewalk())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
