package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{QueryString, MulticastGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartBulkAssociateWirelessDeviceWithMulticastGroupRequest(
    id: MulticastGroupId,
    queryString: Optional[QueryString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest = {
    import StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
      .wrap(buildAwsValue())
}
object StartBulkAssociateWirelessDeviceWithMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest =
      zio.aws.iotwireless.model
        .StartBulkAssociateWirelessDeviceWithMulticastGroupRequest(
          id,
          queryString.map(value => value),
          tags.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def id: MulticastGroupId
    def queryString: Optional[QueryString]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iotwireless.model.primitives.QueryString(value))
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
  ): zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
