package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DeviceCreationFile
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkUpdateImportInfo(
    deviceCreationFile: Optional[DeviceCreationFile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo = {
    import SidewalkUpdateImportInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo
      .builder()
      .optionallyWith(
        deviceCreationFile.map(value =>
          DeviceCreationFile.unwrap(value): java.lang.String
        )
      )(_.deviceCreationFile)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly =
    zio.aws.iotwireless.model.SidewalkUpdateImportInfo.wrap(buildAwsValue())
}
object SidewalkUpdateImportInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkUpdateImportInfo =
      zio.aws.iotwireless.model
        .SidewalkUpdateImportInfo(deviceCreationFile.map(value => value))
    def deviceCreationFile: Optional[DeviceCreationFile]
    def getDeviceCreationFile: ZIO[Any, AwsError, DeviceCreationFile] =
      AwsError.unwrapOptionField("deviceCreationFile", deviceCreationFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo
  ) extends zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly {
    override val deviceCreationFile: Optional[DeviceCreationFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCreationFile())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceCreationFile(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo
  ): zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly = new Wrapper(
    impl
  )
}
