package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkSingleStartImportInfo(
    sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo = {
    import SidewalkSingleStartImportInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo
      .builder()
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly =
    zio.aws.iotwireless.model.SidewalkSingleStartImportInfo
      .wrap(buildAwsValue())
}
object SidewalkSingleStartImportInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkSingleStartImportInfo =
      zio.aws.iotwireless.model.SidewalkSingleStartImportInfo(
        sidewalkManufacturingSn.map(value => value)
      )
    def sidewalkManufacturingSn: Optional[SidewalkManufacturingSn]
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo
  ) extends zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly {
    override val sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo
  ): zio.aws.iotwireless.model.SidewalkSingleStartImportInfo.ReadOnly =
    new Wrapper(impl)
}
