package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.AckModeRetryDurationSecs
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SidewalkSendDataToDevice(
    seq: Optional[zio.aws.iotwireless.model.primitives.Seq] = Optional.Absent,
    messageType: Optional[zio.aws.iotwireless.model.MessageType] =
      Optional.Absent,
    ackModeRetryDurationSecs: Optional[AckModeRetryDurationSecs] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice = {
    import SidewalkSendDataToDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
      .builder()
      .optionallyWith(
        seq.map(value =>
          zio.aws.iotwireless.model.primitives.Seq.unwrap(value): Integer
        )
      )(_.seq)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        ackModeRetryDurationSecs.map(value =>
          AckModeRetryDurationSecs.unwrap(value): Integer
        )
      )(_.ackModeRetryDurationSecs)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkSendDataToDevice.wrap(buildAwsValue())
}
object SidewalkSendDataToDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkSendDataToDevice =
      zio.aws.iotwireless.model.SidewalkSendDataToDevice(
        seq.map(value => value),
        messageType.map(value => value),
        ackModeRetryDurationSecs.map(value => value)
      )
    def seq: Optional[zio.aws.iotwireless.model.primitives.Seq]
    def messageType: Optional[zio.aws.iotwireless.model.MessageType]
    def ackModeRetryDurationSecs: Optional[AckModeRetryDurationSecs]
    def getSeq: ZIO[Any, AwsError, zio.aws.iotwireless.model.primitives.Seq] =
      AwsError.unwrapOptionField("seq", seq)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getAckModeRetryDurationSecs
        : ZIO[Any, AwsError, AckModeRetryDurationSecs] = AwsError
      .unwrapOptionField("ackModeRetryDurationSecs", ackModeRetryDurationSecs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ) extends zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly {
    override val seq: Optional[zio.aws.iotwireless.model.primitives.Seq] =
      zio.aws.core.internal
        .optionalFromNullable(impl.seq())
        .map(value => zio.aws.iotwireless.model.primitives.Seq(value))
    override val messageType: Optional[zio.aws.iotwireless.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.iotwireless.model.MessageType.wrap(value))
    override val ackModeRetryDurationSecs: Optional[AckModeRetryDurationSecs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ackModeRetryDurationSecs())
        .map(value =>
          zio.aws.iotwireless.model.primitives.AckModeRetryDurationSecs(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkSendDataToDevice
  ): zio.aws.iotwireless.model.SidewalkSendDataToDevice.ReadOnly = new Wrapper(
    impl
  )
}
