package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Role, DeviceCreationFile}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkGetStartImportInfo(
    deviceCreationFileList: Optional[Iterable[DeviceCreationFile]] =
      Optional.Absent,
    role: Optional[Role] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo = {
    import SidewalkGetStartImportInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo
      .builder()
      .optionallyWith(
        deviceCreationFileList.map(value =>
          value.map { item =>
            DeviceCreationFile.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deviceCreationFileList)
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly =
    zio.aws.iotwireless.model.SidewalkGetStartImportInfo.wrap(buildAwsValue())
}
object SidewalkGetStartImportInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkGetStartImportInfo =
      zio.aws.iotwireless.model.SidewalkGetStartImportInfo(
        deviceCreationFileList.map(value => value),
        role.map(value => value)
      )
    def deviceCreationFileList: Optional[List[DeviceCreationFile]]
    def role: Optional[Role]
    def getDeviceCreationFileList
        : ZIO[Any, AwsError, List[DeviceCreationFile]] = AwsError
      .unwrapOptionField("deviceCreationFileList", deviceCreationFileList)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo
  ) extends zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly {
    override val deviceCreationFileList: Optional[List[DeviceCreationFile]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCreationFileList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.DeviceCreationFile(item)
          }.toList
        )
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.iotwireless.model.primitives.Role(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo
  ): zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly =
    new Wrapper(impl)
}
