package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  QualificationStatus,
  ApplicationServerPublicKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkGetDeviceProfile(
    applicationServerPublicKey: Optional[ApplicationServerPublicKey] =
      Optional.Absent,
    qualificationStatus: Optional[QualificationStatus] = Optional.Absent,
    dakCertificateMetadata: Optional[
      Iterable[zio.aws.iotwireless.model.DakCertificateMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkGetDeviceProfile = {
    import SidewalkGetDeviceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkGetDeviceProfile
      .builder()
      .optionallyWith(
        applicationServerPublicKey.map(value =>
          ApplicationServerPublicKey.unwrap(value): java.lang.String
        )
      )(_.applicationServerPublicKey)
      .optionallyWith(
        qualificationStatus.map(value =>
          QualificationStatus.unwrap(value): java.lang.Boolean
        )
      )(_.qualificationStatus)
      .optionallyWith(
        dakCertificateMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dakCertificateMetadata)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly =
    zio.aws.iotwireless.model.SidewalkGetDeviceProfile.wrap(buildAwsValue())
}
object SidewalkGetDeviceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkGetDeviceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkGetDeviceProfile =
      zio.aws.iotwireless.model.SidewalkGetDeviceProfile(
        applicationServerPublicKey.map(value => value),
        qualificationStatus.map(value => value),
        dakCertificateMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationServerPublicKey: Optional[ApplicationServerPublicKey]
    def qualificationStatus: Optional[QualificationStatus]
    def dakCertificateMetadata: Optional[
      List[zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly]
    ]
    def getApplicationServerPublicKey
        : ZIO[Any, AwsError, ApplicationServerPublicKey] =
      AwsError.unwrapOptionField(
        "applicationServerPublicKey",
        applicationServerPublicKey
      )
    def getQualificationStatus: ZIO[Any, AwsError, QualificationStatus] =
      AwsError.unwrapOptionField("qualificationStatus", qualificationStatus)
    def getDakCertificateMetadata: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dakCertificateMetadata",
      dakCertificateMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkGetDeviceProfile
  ) extends zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly {
    override val applicationServerPublicKey
        : Optional[ApplicationServerPublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationServerPublicKey())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ApplicationServerPublicKey(value)
      )
    override val qualificationStatus: Optional[QualificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualificationStatus())
        .map(value =>
          zio.aws.iotwireless.model.primitives.QualificationStatus(value)
        )
    override val dakCertificateMetadata: Optional[
      List[zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dakCertificateMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.DakCertificateMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkGetDeviceProfile
  ): zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly = new Wrapper(
    impl
  )
}
