package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkEventNotificationConfigurations(
    amazonIdEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations = {
    import SidewalkEventNotificationConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations
      .builder()
      .optionallyWith(amazonIdEventTopic.map(value => value.unwrap))(
        _.amazonIdEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly =
    zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
      .wrap(buildAwsValue())
}
object SidewalkEventNotificationConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations =
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations(
        amazonIdEventTopic.map(value => value)
      )
    def amazonIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getAmazonIdEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField("amazonIdEventTopic", amazonIdEventTopic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations
  ) extends zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly {
    override val amazonIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amazonIdEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations
  ): zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly =
    new Wrapper(impl)
}
