package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkDeviceMetadata(
    rssi: Optional[Integer] = Optional.Absent,
    batteryLevel: Optional[zio.aws.iotwireless.model.BatteryLevel] =
      Optional.Absent,
    event: Optional[zio.aws.iotwireless.model.Event] = Optional.Absent,
    deviceState: Optional[zio.aws.iotwireless.model.DeviceState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata = {
    import SidewalkDeviceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata
      .builder()
      .optionallyWith(rssi.map(value => value: java.lang.Integer))(_.rssi)
      .optionallyWith(batteryLevel.map(value => value.unwrap))(_.batteryLevel)
      .optionallyWith(event.map(value => value.unwrap))(_.event)
      .optionallyWith(deviceState.map(value => value.unwrap))(_.deviceState)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly =
    zio.aws.iotwireless.model.SidewalkDeviceMetadata.wrap(buildAwsValue())
}
object SidewalkDeviceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkDeviceMetadata =
      zio.aws.iotwireless.model.SidewalkDeviceMetadata(
        rssi.map(value => value),
        batteryLevel.map(value => value),
        event.map(value => value),
        deviceState.map(value => value)
      )
    def rssi: Optional[Integer]
    def batteryLevel: Optional[zio.aws.iotwireless.model.BatteryLevel]
    def event: Optional[zio.aws.iotwireless.model.Event]
    def deviceState: Optional[zio.aws.iotwireless.model.DeviceState]
    def getRssi: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("rssi", rssi)
    def getBatteryLevel
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.BatteryLevel] =
      AwsError.unwrapOptionField("batteryLevel", batteryLevel)
    def getEvent: ZIO[Any, AwsError, zio.aws.iotwireless.model.Event] =
      AwsError.unwrapOptionField("event", event)
    def getDeviceState
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.DeviceState] =
      AwsError.unwrapOptionField("deviceState", deviceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata
  ) extends zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly {
    override val rssi: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.rssi())
      .map(value => value: Integer)
    override val batteryLevel
        : Optional[zio.aws.iotwireless.model.BatteryLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batteryLevel())
        .map(value => zio.aws.iotwireless.model.BatteryLevel.wrap(value))
    override val event: Optional[zio.aws.iotwireless.model.Event] =
      zio.aws.core.internal
        .optionalFromNullable(impl.event())
        .map(value => zio.aws.iotwireless.model.Event.wrap(value))
    override val deviceState: Optional[zio.aws.iotwireless.model.DeviceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceState())
        .map(value => zio.aws.iotwireless.model.DeviceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDeviceMetadata
  ): zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly = new Wrapper(
    impl
  )
}
