package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  AmazonId,
  SidewalkManufacturingSn,
  DeviceProfileId,
  DakCertificateId,
  SidewalkId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkDevice(
    amazonId: Optional[AmazonId] = Optional.Absent,
    sidewalkId: Optional[SidewalkId] = Optional.Absent,
    sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      Optional.Absent,
    deviceCertificates: Optional[
      Iterable[zio.aws.iotwireless.model.CertificateList]
    ] = Optional.Absent,
    privateKeys: Optional[Iterable[zio.aws.iotwireless.model.CertificateList]] =
      Optional.Absent,
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent,
    certificateId: Optional[DakCertificateId] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkDevice = {
    import SidewalkDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        sidewalkId.map(value => SidewalkId.unwrap(value): java.lang.String)
      )(_.sidewalkId)
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .optionallyWith(
        deviceCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceCertificates)
      .optionallyWith(
        privateKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateKeys)
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        certificateId.map(value =>
          DakCertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkDevice.wrap(buildAwsValue())
}
object SidewalkDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkDevice =
      zio.aws.iotwireless.model.SidewalkDevice(
        amazonId.map(value => value),
        sidewalkId.map(value => value),
        sidewalkManufacturingSn.map(value => value),
        deviceCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deviceProfileId.map(value => value),
        certificateId.map(value => value),
        status.map(value => value)
      )
    def amazonId: Optional[AmazonId]
    def sidewalkId: Optional[SidewalkId]
    def sidewalkManufacturingSn: Optional[SidewalkManufacturingSn]
    def deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]]
    def privateKeys
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]]
    def deviceProfileId: Optional[DeviceProfileId]
    def certificateId: Optional[DakCertificateId]
    def status: Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getSidewalkId: ZIO[Any, AwsError, SidewalkId] =
      AwsError.unwrapOptionField("sidewalkId", sidewalkId)
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
    def getDeviceCertificates: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CertificateList.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceCertificates", deviceCertificates)
    def getPrivateKeys: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CertificateList.ReadOnly
    ]] = AwsError.unwrapOptionField("privateKeys", privateKeys)
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getCertificateId: ZIO[Any, AwsError, DakCertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ) extends zio.aws.iotwireless.model.SidewalkDevice.ReadOnly {
    override val amazonId: Optional[AmazonId] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val sidewalkId: Optional[SidewalkId] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalkId())
      .map(value => zio.aws.iotwireless.model.primitives.SidewalkId(value))
    override val sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
    override val deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CertificateList.wrap(item)
          }.toList
        )
    override val privateKeys
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CertificateList.wrap(item)
          }.toList
        )
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
    override val certificateId: Optional[DakCertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DakCertificateId(value)
        )
    override val status
        : Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkDevice
  ): zio.aws.iotwireless.model.SidewalkDevice.ReadOnly = new Wrapper(impl)
}
