package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  PartnerAccountArn,
  Fingerprint,
  AmazonId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkAccountInfoWithFingerprint(
    amazonId: Optional[AmazonId] = Optional.Absent,
    fingerprint: Optional[Fingerprint] = Optional.Absent,
    arn: Optional[PartnerAccountArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint = {
    import SidewalkAccountInfoWithFingerprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        fingerprint.map(value => Fingerprint.unwrap(value): java.lang.String)
      )(_.fingerprint)
      .optionallyWith(
        arn.map(value => PartnerAccountArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly =
    zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint
      .wrap(buildAwsValue())
}
object SidewalkAccountInfoWithFingerprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint =
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint(
        amazonId.map(value => value),
        fingerprint.map(value => value),
        arn.map(value => value)
      )
    def amazonId: Optional[AmazonId]
    def fingerprint: Optional[Fingerprint]
    def arn: Optional[PartnerAccountArn]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getFingerprint: ZIO[Any, AwsError, Fingerprint] =
      AwsError.unwrapOptionField("fingerprint", fingerprint)
    def getArn: ZIO[Any, AwsError, PartnerAccountArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ) extends zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly {
    override val amazonId: Optional[AmazonId] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val fingerprint: Optional[Fingerprint] = zio.aws.core.internal
      .optionalFromNullable(impl.fingerprint())
      .map(value => zio.aws.iotwireless.model.primitives.Fingerprint(value))
    override val arn: Optional[PartnerAccountArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.PartnerAccountArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ): zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly =
    new Wrapper(impl)
}
