package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FPort
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Positioning(
    clockSync: Optional[FPort] = Optional.Absent,
    stream: Optional[FPort] = Optional.Absent,
    gnss: Optional[FPort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.Positioning = {
    import Positioning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Positioning
      .builder()
      .optionallyWith(clockSync.map(value => FPort.unwrap(value): Integer))(
        _.clockSync
      )
      .optionallyWith(stream.map(value => FPort.unwrap(value): Integer))(
        _.stream
      )
      .optionallyWith(gnss.map(value => FPort.unwrap(value): Integer))(_.gnss)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Positioning.ReadOnly =
    zio.aws.iotwireless.model.Positioning.wrap(buildAwsValue())
}
object Positioning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.Positioning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Positioning =
      zio.aws.iotwireless.model.Positioning(
        clockSync.map(value => value),
        stream.map(value => value),
        gnss.map(value => value)
      )
    def clockSync: Optional[FPort]
    def stream: Optional[FPort]
    def gnss: Optional[FPort]
    def getClockSync: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("clockSync", clockSync)
    def getStream: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("stream", stream)
    def getGnss: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("gnss", gnss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Positioning
  ) extends zio.aws.iotwireless.model.Positioning.ReadOnly {
    override val clockSync: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.clockSync())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val stream: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.stream())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val gnss: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.gnss())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Positioning
  ): zio.aws.iotwireless.model.Positioning.ReadOnly = new Wrapper(impl)
}
