package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait PositionResourceType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.PositionResourceType
}
object PositionResourceType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.PositionResourceType
  ): zio.aws.iotwireless.model.PositionResourceType = value match {
    case software.amazon.awssdk.services.iotwireless.model.PositionResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.PositionResourceType.WIRELESS_DEVICE =>
      val r = WirelessDevice
      r
    case software.amazon.awssdk.services.iotwireless.model.PositionResourceType.WIRELESS_GATEWAY =>
      val r = WirelessGateway
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.PositionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionResourceType =
      software.amazon.awssdk.services.iotwireless.model.PositionResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object WirelessDevice
      extends zio.aws.iotwireless.model.PositionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionResourceType =
      software.amazon.awssdk.services.iotwireless.model.PositionResourceType.WIRELESS_DEVICE
  }
  case object WirelessGateway
      extends zio.aws.iotwireless.model.PositionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionResourceType =
      software.amazon.awssdk.services.iotwireless.model.PositionResourceType.WIRELESS_GATEWAY
  }
}
