package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.TransmissionInterval
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ParticipatingGateways(
    downlinkMode: zio.aws.iotwireless.model.DownlinkMode,
    gatewayList: Iterable[zio.aws.iotwireless.model.GatewayListItem],
    transmissionInterval: TransmissionInterval
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ParticipatingGateways = {
    import ParticipatingGateways.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ParticipatingGateways
      .builder()
      .downlinkMode(downlinkMode.unwrap)
      .gatewayList(gatewayList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .transmissionInterval(
        TransmissionInterval.unwrap(transmissionInterval): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ParticipatingGateways.ReadOnly =
    zio.aws.iotwireless.model.ParticipatingGateways.wrap(buildAwsValue())
}
object ParticipatingGateways {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ParticipatingGateways
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ParticipatingGateways =
      zio.aws.iotwireless.model.ParticipatingGateways(
        downlinkMode,
        gatewayList.map { item =>
          item.asEditable
        },
        transmissionInterval
      )
    def downlinkMode: zio.aws.iotwireless.model.DownlinkMode
    def gatewayList: List[zio.aws.iotwireless.model.GatewayListItem.ReadOnly]
    def transmissionInterval: TransmissionInterval
    def getDownlinkMode
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.DownlinkMode] =
      ZIO.succeed(downlinkMode)
    def getGatewayList: ZIO[Any, Nothing, List[
      zio.aws.iotwireless.model.GatewayListItem.ReadOnly
    ]] = ZIO.succeed(gatewayList)
    def getTransmissionInterval: ZIO[Any, Nothing, TransmissionInterval] =
      ZIO.succeed(transmissionInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ParticipatingGateways
  ) extends zio.aws.iotwireless.model.ParticipatingGateways.ReadOnly {
    override val downlinkMode: zio.aws.iotwireless.model.DownlinkMode =
      zio.aws.iotwireless.model.DownlinkMode.wrap(impl.downlinkMode())
    override val gatewayList
        : List[zio.aws.iotwireless.model.GatewayListItem.ReadOnly] = impl
      .gatewayList()
      .asScala
      .map { item =>
        zio.aws.iotwireless.model.GatewayListItem.wrap(item)
      }
      .toList
    override val transmissionInterval: TransmissionInterval =
      zio.aws.iotwireless.model.primitives
        .TransmissionInterval(impl.transmissionInterval())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ParticipatingGateways
  ): zio.aws.iotwireless.model.ParticipatingGateways.ReadOnly = new Wrapper(
    impl
  )
}
