package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{JoinEui, NwkKey, AppKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OtaaV1_1(
    appKey: Optional[AppKey] = Optional.Absent,
    nwkKey: Optional[NwkKey] = Optional.Absent,
    joinEui: Optional[JoinEui] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.OtaaV1_1 = {
    import OtaaV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.OtaaV1_1
      .builder()
      .optionallyWith(
        appKey.map(value => AppKey.unwrap(value): java.lang.String)
      )(_.appKey)
      .optionallyWith(
        nwkKey.map(value => NwkKey.unwrap(value): java.lang.String)
      )(_.nwkKey)
      .optionallyWith(
        joinEui.map(value => JoinEui.unwrap(value): java.lang.String)
      )(_.joinEui)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.OtaaV1_1.ReadOnly =
    zio.aws.iotwireless.model.OtaaV1_1.wrap(buildAwsValue())
}
object OtaaV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.OtaaV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.OtaaV1_1 =
      zio.aws.iotwireless.model.OtaaV1_1(
        appKey.map(value => value),
        nwkKey.map(value => value),
        joinEui.map(value => value)
      )
    def appKey: Optional[AppKey]
    def nwkKey: Optional[NwkKey]
    def joinEui: Optional[JoinEui]
    def getAppKey: ZIO[Any, AwsError, AppKey] =
      AwsError.unwrapOptionField("appKey", appKey)
    def getNwkKey: ZIO[Any, AwsError, NwkKey] =
      AwsError.unwrapOptionField("nwkKey", nwkKey)
    def getJoinEui: ZIO[Any, AwsError, JoinEui] =
      AwsError.unwrapOptionField("joinEui", joinEui)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.OtaaV1_1
  ) extends zio.aws.iotwireless.model.OtaaV1_1.ReadOnly {
    override val appKey: Optional[AppKey] = zio.aws.core.internal
      .optionalFromNullable(impl.appKey())
      .map(value => zio.aws.iotwireless.model.primitives.AppKey(value))
    override val nwkKey: Optional[NwkKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nwkKey())
      .map(value => zio.aws.iotwireless.model.primitives.NwkKey(value))
    override val joinEui: Optional[JoinEui] = zio.aws.core.internal
      .optionalFromNullable(impl.joinEui())
      .map(value => zio.aws.iotwireless.model.primitives.JoinEui(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.OtaaV1_1
  ): zio.aws.iotwireless.model.OtaaV1_1.ReadOnly = new Wrapper(impl)
}
