package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  NetworkAnalyzerConfigurationName,
  NetworkAnalyzerConfigurationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkAnalyzerConfigurations(
    arn: Optional[NetworkAnalyzerConfigurationArn] = Optional.Absent,
    name: Optional[NetworkAnalyzerConfigurationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations = {
    import NetworkAnalyzerConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations
      .builder()
      .optionallyWith(
        arn.map(value =>
          NetworkAnalyzerConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        name.map(value =>
          NetworkAnalyzerConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly =
    zio.aws.iotwireless.model.NetworkAnalyzerConfigurations
      .wrap(buildAwsValue())
}
object NetworkAnalyzerConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.NetworkAnalyzerConfigurations =
      zio.aws.iotwireless.model.NetworkAnalyzerConfigurations(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[NetworkAnalyzerConfigurationArn]
    def name: Optional[NetworkAnalyzerConfigurationName]
    def getArn: ZIO[Any, AwsError, NetworkAnalyzerConfigurationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NetworkAnalyzerConfigurationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations
  ) extends zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly {
    override val arn: Optional[NetworkAnalyzerConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .NetworkAnalyzerConfigurationArn(value)
        )
    override val name: Optional[NetworkAnalyzerConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .NetworkAnalyzerConfigurationName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations
  ): zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly =
    new Wrapper(impl)
}
