package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait MulticastFrameInfo {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo
}
object MulticastFrameInfo {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo
  ): zio.aws.iotwireless.model.MulticastFrameInfo = value match {
    case software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.MulticastFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.iotwireless.model.MulticastFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.ENABLED
  }
  case object DISABLED extends zio.aws.iotwireless.model.MulticastFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.MulticastFrameInfo.DISABLED
  }
}
