package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait MessageType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.MessageType
  ): zio.aws.iotwireless.model.MessageType = value match {
    case software.amazon.awssdk.services.iotwireless.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_NOTIFY =>
      val r = CUSTOM_COMMAND_ID_NOTIFY
      r
    case software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_GET =>
      val r = CUSTOM_COMMAND_ID_GET
      r
    case software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_SET =>
      val r = CUSTOM_COMMAND_ID_SET
      r
    case software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_RESP =>
      val r = CUSTOM_COMMAND_ID_RESP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MessageType =
      software.amazon.awssdk.services.iotwireless.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOM_COMMAND_ID_NOTIFY
      extends zio.aws.iotwireless.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MessageType =
      software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_NOTIFY
  }
  case object CUSTOM_COMMAND_ID_GET
      extends zio.aws.iotwireless.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MessageType =
      software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_GET
  }
  case object CUSTOM_COMMAND_ID_SET
      extends zio.aws.iotwireless.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MessageType =
      software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_SET
  }
  case object CUSTOM_COMMAND_ID_RESP
      extends zio.aws.iotwireless.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.MessageType =
      software.amazon.awssdk.services.iotwireless.model.MessageType.CUSTOM_COMMAND_ID_RESP
  }
}
