package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{RSRQ, EARFCN, EutranCid, RSRP, PCI}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LteNmrObj(
    pci: PCI,
    earfcn: EARFCN,
    eutranCid: EutranCid,
    rsrp: Optional[RSRP] = Optional.Absent,
    rsrq: Optional[RSRQ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LteNmrObj = {
    import LteNmrObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LteNmrObj
      .builder()
      .pci(PCI.unwrap(pci): Integer)
      .earfcn(EARFCN.unwrap(earfcn): Integer)
      .eutranCid(EutranCid.unwrap(eutranCid): Integer)
      .optionallyWith(rsrp.map(value => RSRP.unwrap(value): Integer))(_.rsrp)
      .optionallyWith(rsrq.map(value => RSRQ.unwrap(value): java.lang.Float))(
        _.rsrq
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LteNmrObj.ReadOnly =
    zio.aws.iotwireless.model.LteNmrObj.wrap(buildAwsValue())
}
object LteNmrObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LteNmrObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LteNmrObj =
      zio.aws.iotwireless.model.LteNmrObj(
        pci,
        earfcn,
        eutranCid,
        rsrp.map(value => value),
        rsrq.map(value => value)
      )
    def pci: PCI
    def earfcn: EARFCN
    def eutranCid: EutranCid
    def rsrp: Optional[RSRP]
    def rsrq: Optional[RSRQ]
    def getPci: ZIO[Any, Nothing, PCI] = ZIO.succeed(pci)
    def getEarfcn: ZIO[Any, Nothing, EARFCN] = ZIO.succeed(earfcn)
    def getEutranCid: ZIO[Any, Nothing, EutranCid] = ZIO.succeed(eutranCid)
    def getRsrp: ZIO[Any, AwsError, RSRP] =
      AwsError.unwrapOptionField("rsrp", rsrp)
    def getRsrq: ZIO[Any, AwsError, RSRQ] =
      AwsError.unwrapOptionField("rsrq", rsrq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LteNmrObj
  ) extends zio.aws.iotwireless.model.LteNmrObj.ReadOnly {
    override val pci: PCI = zio.aws.iotwireless.model.primitives.PCI(impl.pci())
    override val earfcn: EARFCN =
      zio.aws.iotwireless.model.primitives.EARFCN(impl.earfcn())
    override val eutranCid: EutranCid =
      zio.aws.iotwireless.model.primitives.EutranCid(impl.eutranCid())
    override val rsrp: Optional[RSRP] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrp())
      .map(value => zio.aws.iotwireless.model.primitives.RSRP(value))
    override val rsrq: Optional[RSRQ] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrq())
      .map(value => zio.aws.iotwireless.model.primitives.RSRQ(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LteNmrObj
  ): zio.aws.iotwireless.model.LteNmrObj.ReadOnly = new Wrapper(impl)
}
