package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Crc, UpdateSignature}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateGatewayTaskCreate(
    updateSignature: Optional[UpdateSignature] = Optional.Absent,
    sigKeyCrc: Optional[Crc] = Optional.Absent,
    currentVersion: Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      Optional.Absent,
    updateVersion: Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate = {
    import LoRaWANUpdateGatewayTaskCreate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
      .builder()
      .optionallyWith(
        updateSignature.map(value =>
          UpdateSignature.unwrap(value): java.lang.String
        )
      )(_.updateSignature)
      .optionallyWith(
        sigKeyCrc.map(value => Crc.unwrap(value): java.lang.Long)
      )(_.sigKeyCrc)
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .optionallyWith(updateVersion.map(value => value.buildAwsValue()))(
        _.updateVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
      .wrap(buildAwsValue())
}
object LoRaWANUpdateGatewayTaskCreate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate =
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate(
        updateSignature.map(value => value),
        sigKeyCrc.map(value => value),
        currentVersion.map(value => value.asEditable),
        updateVersion.map(value => value.asEditable)
      )
    def updateSignature: Optional[UpdateSignature]
    def sigKeyCrc: Optional[Crc]
    def currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def updateVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getUpdateSignature: ZIO[Any, AwsError, UpdateSignature] =
      AwsError.unwrapOptionField("updateSignature", updateSignature)
    def getSigKeyCrc: ZIO[Any, AwsError, Crc] =
      AwsError.unwrapOptionField("sigKeyCrc", sigKeyCrc)
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getUpdateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("updateVersion", updateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly {
    override val updateSignature: Optional[UpdateSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateSignature())
        .map(value =>
          zio.aws.iotwireless.model.primitives.UpdateSignature(value)
        )
    override val sigKeyCrc: Optional[Crc] = zio.aws.core.internal
      .optionalFromNullable(impl.sigKeyCrc())
      .map(value => zio.aws.iotwireless.model.primitives.Crc(value))
    override val currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
    override val updateVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ): zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly =
    new Wrapper(impl)
}
