package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ServiceProfileId, DeviceProfileId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateDevice(
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent,
    serviceProfileId: Optional[ServiceProfileId] = Optional.Absent,
    abpV1_1: Optional[zio.aws.iotwireless.model.UpdateAbpV1_1] =
      Optional.Absent,
    abpV1_0_x: Optional[zio.aws.iotwireless.model.UpdateAbpV1_0_x] =
      Optional.Absent,
    fPorts: Optional[zio.aws.iotwireless.model.UpdateFPorts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice = {
    import LoRaWANUpdateDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
      .builder()
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        serviceProfileId.map(value =>
          ServiceProfileId.unwrap(value): java.lang.String
        )
      )(_.serviceProfileId)
      .optionallyWith(abpV1_1.map(value => value.buildAwsValue()))(_.abpV1_1)
      .optionallyWith(abpV1_0_x.map(value => value.buildAwsValue()))(
        _.abpV1_0_x
      )
      .optionallyWith(fPorts.map(value => value.buildAwsValue()))(_.fPorts)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateDevice.wrap(buildAwsValue())
}
object LoRaWANUpdateDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateDevice =
      zio.aws.iotwireless.model.LoRaWANUpdateDevice(
        deviceProfileId.map(value => value),
        serviceProfileId.map(value => value),
        abpV1_1.map(value => value.asEditable),
        abpV1_0_x.map(value => value.asEditable),
        fPorts.map(value => value.asEditable)
      )
    def deviceProfileId: Optional[DeviceProfileId]
    def serviceProfileId: Optional[ServiceProfileId]
    def abpV1_1: Optional[zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly]
    def abpV1_0_x: Optional[zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly]
    def fPorts: Optional[zio.aws.iotwireless.model.UpdateFPorts.ReadOnly]
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getServiceProfileId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("serviceProfileId", serviceProfileId)
    def getAbpV1_1
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly] =
      AwsError.unwrapOptionField("abpV1_1", abpV1_1)
    def getAbpV1_0_x: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly
    ] = AwsError.unwrapOptionField("abpV1_0_x", abpV1_0_x)
    def getFPorts
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.UpdateFPorts.ReadOnly] =
      AwsError.unwrapOptionField("fPorts", fPorts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly {
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
    override val serviceProfileId: Optional[ServiceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
        )
    override val abpV1_1
        : Optional[zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abpV1_1())
        .map(value => zio.aws.iotwireless.model.UpdateAbpV1_1.wrap(value))
    override val abpV1_0_x
        : Optional[zio.aws.iotwireless.model.UpdateAbpV1_0_x.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abpV1_0_x())
        .map(value => zio.aws.iotwireless.model.UpdateAbpV1_0_x.wrap(value))
    override val fPorts
        : Optional[zio.aws.iotwireless.model.UpdateFPorts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fPorts())
        .map(value => zio.aws.iotwireless.model.UpdateFPorts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateDevice
  ): zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly = new Wrapper(impl)
}
