package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  DrMaxBox,
  DrMinBox,
  AddGwMetadata,
  RaAllowed,
  PrAllowed
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANServiceProfile(
    addGwMetadata: Optional[AddGwMetadata] = Optional.Absent,
    drMin: Optional[DrMinBox] = Optional.Absent,
    drMax: Optional[DrMaxBox] = Optional.Absent,
    prAllowed: Optional[PrAllowed] = Optional.Absent,
    raAllowed: Optional[RaAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile = {
    import LoRaWANServiceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
      .builder()
      .optionallyWith(
        addGwMetadata.map(value =>
          AddGwMetadata.unwrap(value): java.lang.Boolean
        )
      )(_.addGwMetadata)
      .optionallyWith(drMin.map(value => DrMinBox.unwrap(value): Integer))(
        _.drMin
      )
      .optionallyWith(drMax.map(value => DrMaxBox.unwrap(value): Integer))(
        _.drMax
      )
      .optionallyWith(
        prAllowed.map(value => PrAllowed.unwrap(value): java.lang.Boolean)
      )(_.prAllowed)
      .optionallyWith(
        raAllowed.map(value => RaAllowed.unwrap(value): java.lang.Boolean)
      )(_.raAllowed)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANServiceProfile.wrap(buildAwsValue())
}
object LoRaWANServiceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANServiceProfile =
      zio.aws.iotwireless.model.LoRaWANServiceProfile(
        addGwMetadata.map(value => value),
        drMin.map(value => value),
        drMax.map(value => value),
        prAllowed.map(value => value),
        raAllowed.map(value => value)
      )
    def addGwMetadata: Optional[AddGwMetadata]
    def drMin: Optional[DrMinBox]
    def drMax: Optional[DrMaxBox]
    def prAllowed: Optional[PrAllowed]
    def raAllowed: Optional[RaAllowed]
    def getAddGwMetadata: ZIO[Any, AwsError, AddGwMetadata] =
      AwsError.unwrapOptionField("addGwMetadata", addGwMetadata)
    def getDrMin: ZIO[Any, AwsError, DrMinBox] =
      AwsError.unwrapOptionField("drMin", drMin)
    def getDrMax: ZIO[Any, AwsError, DrMaxBox] =
      AwsError.unwrapOptionField("drMax", drMax)
    def getPrAllowed: ZIO[Any, AwsError, PrAllowed] =
      AwsError.unwrapOptionField("prAllowed", prAllowed)
    def getRaAllowed: ZIO[Any, AwsError, RaAllowed] =
      AwsError.unwrapOptionField("raAllowed", raAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ) extends zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly {
    override val addGwMetadata: Optional[AddGwMetadata] = zio.aws.core.internal
      .optionalFromNullable(impl.addGwMetadata())
      .map(value => zio.aws.iotwireless.model.primitives.AddGwMetadata(value))
    override val drMin: Optional[DrMinBox] = zio.aws.core.internal
      .optionalFromNullable(impl.drMin())
      .map(value => zio.aws.iotwireless.model.primitives.DrMinBox(value))
    override val drMax: Optional[DrMaxBox] = zio.aws.core.internal
      .optionalFromNullable(impl.drMax())
      .map(value => zio.aws.iotwireless.model.primitives.DrMaxBox(value))
    override val prAllowed: Optional[PrAllowed] = zio.aws.core.internal
      .optionalFromNullable(impl.prAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.PrAllowed(value))
    override val raAllowed: Optional[RaAllowed] = zio.aws.core.internal
      .optionalFromNullable(impl.raAllowed())
      .map(value => zio.aws.iotwireless.model.primitives.RaAllowed(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ): zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly = new Wrapper(
    impl
  )
}
