package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Station, Model, PackageVersion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANGatewayVersion(
    packageVersion: Optional[PackageVersion] = Optional.Absent,
    model: Optional[Model] = Optional.Absent,
    station: Optional[Station] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion = {
    import LoRaWANGatewayVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
      .builder()
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        model.map(value => Model.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        station.map(value => Station.unwrap(value): java.lang.String)
      )(_.station)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(buildAwsValue())
}
object LoRaWANGatewayVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGatewayVersion =
      zio.aws.iotwireless.model.LoRaWANGatewayVersion(
        packageVersion.map(value => value),
        model.map(value => value),
        station.map(value => value)
      )
    def packageVersion: Optional[PackageVersion]
    def model: Optional[Model]
    def station: Optional[Station]
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getModel: ZIO[Any, AwsError, Model] =
      AwsError.unwrapOptionField("model", model)
    def getStation: ZIO[Any, AwsError, Station] =
      AwsError.unwrapOptionField("station", station)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ) extends zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly {
    override val packageVersion: Optional[PackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.iotwireless.model.primitives.PackageVersion(value)
        )
    override val model: Optional[Model] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => zio.aws.iotwireless.model.primitives.Model(value))
    override val station: Optional[Station] = zio.aws.core.internal
      .optionalFromNullable(impl.station())
      .map(value => zio.aws.iotwireless.model.primitives.Station(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayVersion
  ): zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly = new Wrapper(
    impl
  )
}
