package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  Supports32BitFCnt,
  RxFreq2,
  RxDataRate2,
  RegParamsRevision,
  PingSlotFreq,
  SupportsClassC,
  PingSlotDr,
  PingSlotPeriod,
  MacVersion,
  PresetFreq,
  ClassCTimeout,
  MaxEirp,
  RxDelay1,
  ClassBTimeout,
  RxDrOffset1,
  MaxDutyCycle,
  SupportsJoin,
  RfRegion,
  SupportsClassB
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANDeviceProfile(
    supportsClassB: Optional[SupportsClassB] = Optional.Absent,
    classBTimeout: Optional[ClassBTimeout] = Optional.Absent,
    pingSlotPeriod: Optional[PingSlotPeriod] = Optional.Absent,
    pingSlotDr: Optional[PingSlotDr] = Optional.Absent,
    pingSlotFreq: Optional[PingSlotFreq] = Optional.Absent,
    supportsClassC: Optional[SupportsClassC] = Optional.Absent,
    classCTimeout: Optional[ClassCTimeout] = Optional.Absent,
    macVersion: Optional[MacVersion] = Optional.Absent,
    regParamsRevision: Optional[RegParamsRevision] = Optional.Absent,
    rxDelay1: Optional[RxDelay1] = Optional.Absent,
    rxDrOffset1: Optional[RxDrOffset1] = Optional.Absent,
    rxDataRate2: Optional[RxDataRate2] = Optional.Absent,
    rxFreq2: Optional[RxFreq2] = Optional.Absent,
    factoryPresetFreqsList: Optional[Iterable[PresetFreq]] = Optional.Absent,
    maxEirp: Optional[MaxEirp] = Optional.Absent,
    maxDutyCycle: Optional[MaxDutyCycle] = Optional.Absent,
    rfRegion: Optional[RfRegion] = Optional.Absent,
    supportsJoin: Optional[SupportsJoin] = Optional.Absent,
    supports32BitFCnt: Optional[Supports32BitFCnt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile = {
    import LoRaWANDeviceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
      .builder()
      .optionallyWith(
        supportsClassB.map(value =>
          SupportsClassB.unwrap(value): java.lang.Boolean
        )
      )(_.supportsClassB)
      .optionallyWith(
        classBTimeout.map(value => ClassBTimeout.unwrap(value): Integer)
      )(_.classBTimeout)
      .optionallyWith(
        pingSlotPeriod.map(value => PingSlotPeriod.unwrap(value): Integer)
      )(_.pingSlotPeriod)
      .optionallyWith(
        pingSlotDr.map(value => PingSlotDr.unwrap(value): Integer)
      )(_.pingSlotDr)
      .optionallyWith(
        pingSlotFreq.map(value => PingSlotFreq.unwrap(value): Integer)
      )(_.pingSlotFreq)
      .optionallyWith(
        supportsClassC.map(value =>
          SupportsClassC.unwrap(value): java.lang.Boolean
        )
      )(_.supportsClassC)
      .optionallyWith(
        classCTimeout.map(value => ClassCTimeout.unwrap(value): Integer)
      )(_.classCTimeout)
      .optionallyWith(
        macVersion.map(value => MacVersion.unwrap(value): java.lang.String)
      )(_.macVersion)
      .optionallyWith(
        regParamsRevision.map(value =>
          RegParamsRevision.unwrap(value): java.lang.String
        )
      )(_.regParamsRevision)
      .optionallyWith(rxDelay1.map(value => RxDelay1.unwrap(value): Integer))(
        _.rxDelay1
      )
      .optionallyWith(
        rxDrOffset1.map(value => RxDrOffset1.unwrap(value): Integer)
      )(_.rxDrOffset1)
      .optionallyWith(
        rxDataRate2.map(value => RxDataRate2.unwrap(value): Integer)
      )(_.rxDataRate2)
      .optionallyWith(rxFreq2.map(value => RxFreq2.unwrap(value): Integer))(
        _.rxFreq2
      )
      .optionallyWith(
        factoryPresetFreqsList.map(value =>
          value.map { item =>
            PresetFreq.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.factoryPresetFreqsList)
      .optionallyWith(maxEirp.map(value => MaxEirp.unwrap(value): Integer))(
        _.maxEirp
      )
      .optionallyWith(
        maxDutyCycle.map(value => MaxDutyCycle.unwrap(value): Integer)
      )(_.maxDutyCycle)
      .optionallyWith(
        rfRegion.map(value => RfRegion.unwrap(value): java.lang.String)
      )(_.rfRegion)
      .optionallyWith(
        supportsJoin.map(value => SupportsJoin.unwrap(value): java.lang.Boolean)
      )(_.supportsJoin)
      .optionallyWith(
        supports32BitFCnt.map(value =>
          Supports32BitFCnt.unwrap(value): java.lang.Boolean
        )
      )(_.supports32BitFCnt)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(buildAwsValue())
}
object LoRaWANDeviceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANDeviceProfile =
      zio.aws.iotwireless.model.LoRaWANDeviceProfile(
        supportsClassB.map(value => value),
        classBTimeout.map(value => value),
        pingSlotPeriod.map(value => value),
        pingSlotDr.map(value => value),
        pingSlotFreq.map(value => value),
        supportsClassC.map(value => value),
        classCTimeout.map(value => value),
        macVersion.map(value => value),
        regParamsRevision.map(value => value),
        rxDelay1.map(value => value),
        rxDrOffset1.map(value => value),
        rxDataRate2.map(value => value),
        rxFreq2.map(value => value),
        factoryPresetFreqsList.map(value => value),
        maxEirp.map(value => value),
        maxDutyCycle.map(value => value),
        rfRegion.map(value => value),
        supportsJoin.map(value => value),
        supports32BitFCnt.map(value => value)
      )
    def supportsClassB: Optional[SupportsClassB]
    def classBTimeout: Optional[ClassBTimeout]
    def pingSlotPeriod: Optional[PingSlotPeriod]
    def pingSlotDr: Optional[PingSlotDr]
    def pingSlotFreq: Optional[PingSlotFreq]
    def supportsClassC: Optional[SupportsClassC]
    def classCTimeout: Optional[ClassCTimeout]
    def macVersion: Optional[MacVersion]
    def regParamsRevision: Optional[RegParamsRevision]
    def rxDelay1: Optional[RxDelay1]
    def rxDrOffset1: Optional[RxDrOffset1]
    def rxDataRate2: Optional[RxDataRate2]
    def rxFreq2: Optional[RxFreq2]
    def factoryPresetFreqsList: Optional[List[PresetFreq]]
    def maxEirp: Optional[MaxEirp]
    def maxDutyCycle: Optional[MaxDutyCycle]
    def rfRegion: Optional[RfRegion]
    def supportsJoin: Optional[SupportsJoin]
    def supports32BitFCnt: Optional[Supports32BitFCnt]
    def getSupportsClassB: ZIO[Any, AwsError, SupportsClassB] =
      AwsError.unwrapOptionField("supportsClassB", supportsClassB)
    def getClassBTimeout: ZIO[Any, AwsError, ClassBTimeout] =
      AwsError.unwrapOptionField("classBTimeout", classBTimeout)
    def getPingSlotPeriod: ZIO[Any, AwsError, PingSlotPeriod] =
      AwsError.unwrapOptionField("pingSlotPeriod", pingSlotPeriod)
    def getPingSlotDr: ZIO[Any, AwsError, PingSlotDr] =
      AwsError.unwrapOptionField("pingSlotDr", pingSlotDr)
    def getPingSlotFreq: ZIO[Any, AwsError, PingSlotFreq] =
      AwsError.unwrapOptionField("pingSlotFreq", pingSlotFreq)
    def getSupportsClassC: ZIO[Any, AwsError, SupportsClassC] =
      AwsError.unwrapOptionField("supportsClassC", supportsClassC)
    def getClassCTimeout: ZIO[Any, AwsError, ClassCTimeout] =
      AwsError.unwrapOptionField("classCTimeout", classCTimeout)
    def getMacVersion: ZIO[Any, AwsError, MacVersion] =
      AwsError.unwrapOptionField("macVersion", macVersion)
    def getRegParamsRevision: ZIO[Any, AwsError, RegParamsRevision] =
      AwsError.unwrapOptionField("regParamsRevision", regParamsRevision)
    def getRxDelay1: ZIO[Any, AwsError, RxDelay1] =
      AwsError.unwrapOptionField("rxDelay1", rxDelay1)
    def getRxDrOffset1: ZIO[Any, AwsError, RxDrOffset1] =
      AwsError.unwrapOptionField("rxDrOffset1", rxDrOffset1)
    def getRxDataRate2: ZIO[Any, AwsError, RxDataRate2] =
      AwsError.unwrapOptionField("rxDataRate2", rxDataRate2)
    def getRxFreq2: ZIO[Any, AwsError, RxFreq2] =
      AwsError.unwrapOptionField("rxFreq2", rxFreq2)
    def getFactoryPresetFreqsList: ZIO[Any, AwsError, List[PresetFreq]] =
      AwsError.unwrapOptionField(
        "factoryPresetFreqsList",
        factoryPresetFreqsList
      )
    def getMaxEirp: ZIO[Any, AwsError, MaxEirp] =
      AwsError.unwrapOptionField("maxEirp", maxEirp)
    def getMaxDutyCycle: ZIO[Any, AwsError, MaxDutyCycle] =
      AwsError.unwrapOptionField("maxDutyCycle", maxDutyCycle)
    def getRfRegion: ZIO[Any, AwsError, RfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getSupportsJoin: ZIO[Any, AwsError, SupportsJoin] =
      AwsError.unwrapOptionField("supportsJoin", supportsJoin)
    def getSupports32BitFCnt: ZIO[Any, AwsError, Supports32BitFCnt] =
      AwsError.unwrapOptionField("supports32BitFCnt", supports32BitFCnt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ) extends zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly {
    override val supportsClassB: Optional[SupportsClassB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsClassB())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SupportsClassB(value)
        )
    override val classBTimeout: Optional[ClassBTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.classBTimeout())
      .map(value => zio.aws.iotwireless.model.primitives.ClassBTimeout(value))
    override val pingSlotPeriod: Optional[PingSlotPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pingSlotPeriod())
        .map(value =>
          zio.aws.iotwireless.model.primitives.PingSlotPeriod(value)
        )
    override val pingSlotDr: Optional[PingSlotDr] = zio.aws.core.internal
      .optionalFromNullable(impl.pingSlotDr())
      .map(value => zio.aws.iotwireless.model.primitives.PingSlotDr(value))
    override val pingSlotFreq: Optional[PingSlotFreq] = zio.aws.core.internal
      .optionalFromNullable(impl.pingSlotFreq())
      .map(value => zio.aws.iotwireless.model.primitives.PingSlotFreq(value))
    override val supportsClassC: Optional[SupportsClassC] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsClassC())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SupportsClassC(value)
        )
    override val classCTimeout: Optional[ClassCTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.classCTimeout())
      .map(value => zio.aws.iotwireless.model.primitives.ClassCTimeout(value))
    override val macVersion: Optional[MacVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.macVersion())
      .map(value => zio.aws.iotwireless.model.primitives.MacVersion(value))
    override val regParamsRevision: Optional[RegParamsRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regParamsRevision())
        .map(value =>
          zio.aws.iotwireless.model.primitives.RegParamsRevision(value)
        )
    override val rxDelay1: Optional[RxDelay1] = zio.aws.core.internal
      .optionalFromNullable(impl.rxDelay1())
      .map(value => zio.aws.iotwireless.model.primitives.RxDelay1(value))
    override val rxDrOffset1: Optional[RxDrOffset1] = zio.aws.core.internal
      .optionalFromNullable(impl.rxDrOffset1())
      .map(value => zio.aws.iotwireless.model.primitives.RxDrOffset1(value))
    override val rxDataRate2: Optional[RxDataRate2] = zio.aws.core.internal
      .optionalFromNullable(impl.rxDataRate2())
      .map(value => zio.aws.iotwireless.model.primitives.RxDataRate2(value))
    override val rxFreq2: Optional[RxFreq2] = zio.aws.core.internal
      .optionalFromNullable(impl.rxFreq2())
      .map(value => zio.aws.iotwireless.model.primitives.RxFreq2(value))
    override val factoryPresetFreqsList: Optional[List[PresetFreq]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.factoryPresetFreqsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.PresetFreq(item)
          }.toList
        )
    override val maxEirp: Optional[MaxEirp] = zio.aws.core.internal
      .optionalFromNullable(impl.maxEirp())
      .map(value => zio.aws.iotwireless.model.primitives.MaxEirp(value))
    override val maxDutyCycle: Optional[MaxDutyCycle] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDutyCycle())
      .map(value => zio.aws.iotwireless.model.primitives.MaxDutyCycle(value))
    override val rfRegion: Optional[RfRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.rfRegion())
      .map(value => zio.aws.iotwireless.model.primitives.RfRegion(value))
    override val supportsJoin: Optional[SupportsJoin] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsJoin())
      .map(value => zio.aws.iotwireless.model.primitives.SupportsJoin(value))
    override val supports32BitFCnt: Optional[Supports32BitFCnt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supports32BitFCnt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.Supports32BitFCnt(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceProfile
  ): zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly = new Wrapper(impl)
}
