package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANConnectionStatusResourceTypeEventConfiguration(
    wirelessGatewayEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration = {
    import LoRaWANConnectionStatusResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
      .builder()
      .optionallyWith(wirelessGatewayEventTopic.map(value => value.unwrap))(
        _.wirelessGatewayEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object LoRaWANConnectionStatusResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration =
      zio.aws.iotwireless.model
        .LoRaWANConnectionStatusResourceTypeEventConfiguration(
          wirelessGatewayEventTopic.map(value => value)
        )
    def wirelessGatewayEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getWirelessGatewayEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField(
      "wirelessGatewayEventTopic",
      wirelessGatewayEventTopic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly {
    override val wirelessGatewayEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewayEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.LoRaWANConnectionStatusResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
