package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  NextToken,
  MulticastGroupId,
  DeviceProfileId,
  MaxResults,
  FuotaTaskId,
  DestinationName,
  ServiceProfileId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWirelessDevicesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent,
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent,
    serviceProfileId: Optional[ServiceProfileId] = Optional.Absent,
    wirelessDeviceType: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent,
    fuotaTaskId: Optional[FuotaTaskId] = Optional.Absent,
    multicastGroupId: Optional[MulticastGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest = {
    import ListWirelessDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(
        serviceProfileId.map(value =>
          ServiceProfileId.unwrap(value): java.lang.String
        )
      )(_.serviceProfileId)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .optionallyWith(
        fuotaTaskId.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.fuotaTaskId)
      .optionallyWith(
        multicastGroupId.map(value =>
          MulticastGroupId.unwrap(value): java.lang.String
        )
      )(_.multicastGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessDevicesRequest.wrap(buildAwsValue())
}
object ListWirelessDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListWirelessDevicesRequest =
      zio.aws.iotwireless.model.ListWirelessDevicesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        destinationName.map(value => value),
        deviceProfileId.map(value => value),
        serviceProfileId.map(value => value),
        wirelessDeviceType.map(value => value),
        fuotaTaskId.map(value => value),
        multicastGroupId.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def destinationName: Optional[DestinationName]
    def deviceProfileId: Optional[DeviceProfileId]
    def serviceProfileId: Optional[ServiceProfileId]
    def wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def fuotaTaskId: Optional[FuotaTaskId]
    def multicastGroupId: Optional[MulticastGroupId]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getServiceProfileId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("serviceProfileId", serviceProfileId)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
    def getFuotaTaskId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("fuotaTaskId", fuotaTaskId)
    def getMulticastGroupId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("multicastGroupId", multicastGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ) extends zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
    override val serviceProfileId: Optional[ServiceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
        )
    override val wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceType())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val fuotaTaskId: Optional[FuotaTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.fuotaTaskId())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
    override val multicastGroupId: Optional[MulticastGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multicastGroupId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest
  ): zio.aws.iotwireless.model.ListWirelessDevicesRequest.ReadOnly =
    new Wrapper(impl)
}
