package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEventConfigurationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    eventConfigurationsList: Optional[
      Iterable[zio.aws.iotwireless.model.EventConfigurationItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse = {
    import ListEventConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        eventConfigurationsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventConfigurationsList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListEventConfigurationsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListEventConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListEventConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListEventConfigurationsResponse =
      zio.aws.iotwireless.model.ListEventConfigurationsResponse(
        nextToken.map(value => value),
        eventConfigurationsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def eventConfigurationsList: Optional[
      List[zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEventConfigurationsList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventConfigurationsList",
      eventConfigurationsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse
  ) extends zio.aws.iotwireless.model.ListEventConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val eventConfigurationsList: Optional[
      List[zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventConfigurationsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.EventConfigurationItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListEventConfigurationsResponse
  ): zio.aws.iotwireless.model.ListEventConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
