package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.IPAddress
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Ip(ipAddress: IPAddress) {
  def buildAwsValue(): software.amazon.awssdk.services.iotwireless.model.Ip = {
    import Ip.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Ip
      .builder()
      .ipAddress(IPAddress.unwrap(ipAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Ip.ReadOnly =
    zio.aws.iotwireless.model.Ip.wrap(buildAwsValue())
}
object Ip {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotwireless.model.Ip] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Ip =
      zio.aws.iotwireless.model.Ip(ipAddress)
    def ipAddress: IPAddress
    def getIpAddress: ZIO[Any, Nothing, IPAddress] = ZIO.succeed(ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Ip
  ) extends zio.aws.iotwireless.model.Ip.ReadOnly {
    override val ipAddress: IPAddress =
      zio.aws.iotwireless.model.primitives.IPAddress(impl.ipAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Ip
  ): zio.aws.iotwireless.model.Ip.ReadOnly = new Wrapper(impl)
}
