package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportedWirelessDevice(
    sidewalk: Optional[zio.aws.iotwireless.model.ImportedSidewalkDevice] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice = {
    import ImportedWirelessDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly =
    zio.aws.iotwireless.model.ImportedWirelessDevice.wrap(buildAwsValue())
}
object ImportedWirelessDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ImportedWirelessDevice =
      zio.aws.iotwireless.model
        .ImportedWirelessDevice(sidewalk.map(value => value.asEditable))
    def sidewalk
        : Optional[zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice
  ) extends zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly {
    override val sidewalk
        : Optional[zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalk())
        .map(value =>
          zio.aws.iotwireless.model.ImportedSidewalkDevice.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice
  ): zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly = new Wrapper(
    impl
  )
}
