package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait IdentifierType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.IdentifierType
}
object IdentifierType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.IdentifierType
  ): zio.aws.iotwireless.model.IdentifierType = value match {
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.PARTNER_ACCOUNT_ID =>
      val r = PartnerAccountId
      r
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.DEV_EUI =>
      val r = DevEui
      r
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.GATEWAY_EUI =>
      val r = GatewayEui
      r
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.WIRELESS_DEVICE_ID =>
      val r = WirelessDeviceId
      r
    case software.amazon.awssdk.services.iotwireless.model.IdentifierType.WIRELESS_GATEWAY_ID =>
      val r = WirelessGatewayId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.UNKNOWN_TO_SDK_VERSION
  }
  case object PartnerAccountId
      extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.PARTNER_ACCOUNT_ID
  }
  case object DevEui extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.DEV_EUI
  }
  case object GatewayEui extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.GATEWAY_EUI
  }
  case object WirelessDeviceId
      extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.WIRELESS_DEVICE_ID
  }
  case object WirelessGatewayId
      extends zio.aws.iotwireless.model.IdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.IdentifierType =
      software.amazon.awssdk.services.iotwireless.model.IdentifierType.WIRELESS_GATEWAY_ID
  }
}
