package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  GeranCid,
  LAC,
  MCC,
  MNC,
  GsmTimingAdvance,
  RxLevel
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GsmObj(
    mcc: MCC,
    mnc: MNC,
    lac: LAC,
    geranCid: GeranCid,
    gsmLocalId: Optional[zio.aws.iotwireless.model.GsmLocalId] =
      Optional.Absent,
    gsmTimingAdvance: Optional[GsmTimingAdvance] = Optional.Absent,
    rxLevel: Optional[RxLevel] = Optional.Absent,
    gsmNmr: Optional[Iterable[zio.aws.iotwireless.model.GsmNmrObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GsmObj = {
    import GsmObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GsmObj
      .builder()
      .mcc(MCC.unwrap(mcc): Integer)
      .mnc(MNC.unwrap(mnc): Integer)
      .lac(LAC.unwrap(lac): Integer)
      .geranCid(GeranCid.unwrap(geranCid): Integer)
      .optionallyWith(gsmLocalId.map(value => value.buildAwsValue()))(
        _.gsmLocalId
      )
      .optionallyWith(
        gsmTimingAdvance.map(value => GsmTimingAdvance.unwrap(value): Integer)
      )(_.gsmTimingAdvance)
      .optionallyWith(rxLevel.map(value => RxLevel.unwrap(value): Integer))(
        _.rxLevel
      )
      .optionallyWith(
        gsmNmr.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gsmNmr)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GsmObj.ReadOnly =
    zio.aws.iotwireless.model.GsmObj.wrap(buildAwsValue())
}
object GsmObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GsmObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GsmObj =
      zio.aws.iotwireless.model.GsmObj(
        mcc,
        mnc,
        lac,
        geranCid,
        gsmLocalId.map(value => value.asEditable),
        gsmTimingAdvance.map(value => value),
        rxLevel.map(value => value),
        gsmNmr.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mcc: MCC
    def mnc: MNC
    def lac: LAC
    def geranCid: GeranCid
    def gsmLocalId: Optional[zio.aws.iotwireless.model.GsmLocalId.ReadOnly]
    def gsmTimingAdvance: Optional[GsmTimingAdvance]
    def rxLevel: Optional[RxLevel]
    def gsmNmr: Optional[List[zio.aws.iotwireless.model.GsmNmrObj.ReadOnly]]
    def getMcc: ZIO[Any, Nothing, MCC] = ZIO.succeed(mcc)
    def getMnc: ZIO[Any, Nothing, MNC] = ZIO.succeed(mnc)
    def getLac: ZIO[Any, Nothing, LAC] = ZIO.succeed(lac)
    def getGeranCid: ZIO[Any, Nothing, GeranCid] = ZIO.succeed(geranCid)
    def getGsmLocalId
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.GsmLocalId.ReadOnly] =
      AwsError.unwrapOptionField("gsmLocalId", gsmLocalId)
    def getGsmTimingAdvance: ZIO[Any, AwsError, GsmTimingAdvance] =
      AwsError.unwrapOptionField("gsmTimingAdvance", gsmTimingAdvance)
    def getRxLevel: ZIO[Any, AwsError, RxLevel] =
      AwsError.unwrapOptionField("rxLevel", rxLevel)
    def getGsmNmr: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.GsmNmrObj.ReadOnly
    ]] = AwsError.unwrapOptionField("gsmNmr", gsmNmr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmObj
  ) extends zio.aws.iotwireless.model.GsmObj.ReadOnly {
    override val mcc: MCC = zio.aws.iotwireless.model.primitives.MCC(impl.mcc())
    override val mnc: MNC = zio.aws.iotwireless.model.primitives.MNC(impl.mnc())
    override val lac: LAC = zio.aws.iotwireless.model.primitives.LAC(impl.lac())
    override val geranCid: GeranCid =
      zio.aws.iotwireless.model.primitives.GeranCid(impl.geranCid())
    override val gsmLocalId
        : Optional[zio.aws.iotwireless.model.GsmLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gsmLocalId())
        .map(value => zio.aws.iotwireless.model.GsmLocalId.wrap(value))
    override val gsmTimingAdvance: Optional[GsmTimingAdvance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gsmTimingAdvance())
        .map(value =>
          zio.aws.iotwireless.model.primitives.GsmTimingAdvance(value)
        )
    override val rxLevel: Optional[RxLevel] = zio.aws.core.internal
      .optionalFromNullable(impl.rxLevel())
      .map(value => zio.aws.iotwireless.model.primitives.RxLevel(value))
    override val gsmNmr
        : Optional[List[zio.aws.iotwireless.model.GsmNmrObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gsmNmr())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.GsmNmrObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmObj
  ): zio.aws.iotwireless.model.GsmObj.ReadOnly = new Wrapper(impl)
}
