package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{RxLevel, BCCH, BSIC}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GsmNmrObj(
    bsic: BSIC,
    bcch: BCCH,
    rxLevel: Optional[RxLevel] = Optional.Absent,
    globalIdentity: Optional[zio.aws.iotwireless.model.GlobalIdentity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GsmNmrObj = {
    import GsmNmrObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GsmNmrObj
      .builder()
      .bsic(BSIC.unwrap(bsic): Integer)
      .bcch(BCCH.unwrap(bcch): Integer)
      .optionallyWith(rxLevel.map(value => RxLevel.unwrap(value): Integer))(
        _.rxLevel
      )
      .optionallyWith(globalIdentity.map(value => value.buildAwsValue()))(
        _.globalIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GsmNmrObj.ReadOnly =
    zio.aws.iotwireless.model.GsmNmrObj.wrap(buildAwsValue())
}
object GsmNmrObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GsmNmrObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GsmNmrObj =
      zio.aws.iotwireless.model.GsmNmrObj(
        bsic,
        bcch,
        rxLevel.map(value => value),
        globalIdentity.map(value => value.asEditable)
      )
    def bsic: BSIC
    def bcch: BCCH
    def rxLevel: Optional[RxLevel]
    def globalIdentity
        : Optional[zio.aws.iotwireless.model.GlobalIdentity.ReadOnly]
    def getBsic: ZIO[Any, Nothing, BSIC] = ZIO.succeed(bsic)
    def getBcch: ZIO[Any, Nothing, BCCH] = ZIO.succeed(bcch)
    def getRxLevel: ZIO[Any, AwsError, RxLevel] =
      AwsError.unwrapOptionField("rxLevel", rxLevel)
    def getGlobalIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.GlobalIdentity.ReadOnly
    ] = AwsError.unwrapOptionField("globalIdentity", globalIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmNmrObj
  ) extends zio.aws.iotwireless.model.GsmNmrObj.ReadOnly {
    override val bsic: BSIC =
      zio.aws.iotwireless.model.primitives.BSIC(impl.bsic())
    override val bcch: BCCH =
      zio.aws.iotwireless.model.primitives.BCCH(impl.bcch())
    override val rxLevel: Optional[RxLevel] = zio.aws.core.internal
      .optionalFromNullable(impl.rxLevel())
      .map(value => zio.aws.iotwireless.model.primitives.RxLevel(value))
    override val globalIdentity
        : Optional[zio.aws.iotwireless.model.GlobalIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalIdentity())
        .map(value => zio.aws.iotwireless.model.GlobalIdentity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmNmrObj
  ): zio.aws.iotwireless.model.GsmNmrObj.ReadOnly = new Wrapper(impl)
}
