package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{BCCH, BSIC}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GsmLocalId(bsic: BSIC, bcch: BCCH) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GsmLocalId = {
    import GsmLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GsmLocalId
      .builder()
      .bsic(BSIC.unwrap(bsic): Integer)
      .bcch(BCCH.unwrap(bcch): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GsmLocalId.ReadOnly =
    zio.aws.iotwireless.model.GsmLocalId.wrap(buildAwsValue())
}
object GsmLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GsmLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GsmLocalId =
      zio.aws.iotwireless.model.GsmLocalId(bsic, bcch)
    def bsic: BSIC
    def bcch: BCCH
    def getBsic: ZIO[Any, Nothing, BSIC] = ZIO.succeed(bsic)
    def getBcch: ZIO[Any, Nothing, BCCH] = ZIO.succeed(bcch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmLocalId
  ) extends zio.aws.iotwireless.model.GsmLocalId.ReadOnly {
    override val bsic: BSIC =
      zio.aws.iotwireless.model.primitives.BSIC(impl.bsic())
    override val bcch: BCCH =
      zio.aws.iotwireless.model.primitives.BCCH(impl.bcch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GsmLocalId
  ): zio.aws.iotwireless.model.GsmLocalId.ReadOnly = new Wrapper(impl)
}
