package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayStatisticsResponse(
    wirelessGatewayId: Optional[WirelessGatewayId] = Optional.Absent,
    lastUplinkReceivedAt: Optional[ISODateTimeString] = Optional.Absent,
    connectionStatus: Optional[zio.aws.iotwireless.model.ConnectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse = {
    import GetWirelessGatewayStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
      .builder()
      .optionallyWith(
        wirelessGatewayId.map(value =>
          WirelessGatewayId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayId)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse(
        wirelessGatewayId.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        connectionStatus.map(value => value)
      )
    def wirelessGatewayId: Optional[WirelessGatewayId]
    def lastUplinkReceivedAt: Optional[ISODateTimeString]
    def connectionStatus: Optional[zio.aws.iotwireless.model.ConnectionStatus]
    def getWirelessGatewayId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("wirelessGatewayId", wirelessGatewayId)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getConnectionStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ConnectionStatus] =
      AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly {
    override val wirelessGatewayId: Optional[WirelessGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewayId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
        )
    override val lastUplinkReceivedAt: Optional[ISODateTimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUplinkReceivedAt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
        )
    override val connectionStatus
        : Optional[zio.aws.iotwireless.model.ConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value => zio.aws.iotwireless.model.ConnectionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
