package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayCertificateRequest(id: WirelessGatewayId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest = {
    import GetWirelessGatewayCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest
      .wrap(buildAwsValue())
}
object GetWirelessGatewayCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest =
      zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest(id)
    def id: WirelessGatewayId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayCertificateRequest
  ): zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
