package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ImportTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceImportTaskRequest(id: ImportTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest = {
    import GetWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest
      .builder()
      .id(ImportTaskId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object GetWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest(id)
    def id: ImportTaskId
    def getId: ZIO[Any, Nothing, ImportTaskId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest.ReadOnly {
    override val id: ImportTaskId =
      zio.aws.iotwireless.model.primitives.ImportTaskId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.GetWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
