package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NetworkAnalyzerConfigurationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetNetworkAnalyzerConfigurationRequest(
    configurationName: NetworkAnalyzerConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest = {
    import GetNetworkAnalyzerConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
      .builder()
      .configurationName(
        NetworkAnalyzerConfigurationName.unwrap(
          configurationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
      .wrap(buildAwsValue())
}
object GetNetworkAnalyzerConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest =
      zio.aws.iotwireless.model
        .GetNetworkAnalyzerConfigurationRequest(configurationName)
    def configurationName: NetworkAnalyzerConfigurationName
    def getConfigurationName
        : ZIO[Any, Nothing, NetworkAnalyzerConfigurationName] =
      ZIO.succeed(configurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
  ) extends zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest.ReadOnly {
    override val configurationName: NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives
        .NetworkAnalyzerConfigurationName(impl.configurationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
  ): zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
