package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventConfigurationItem(
    identifier: Optional[Identifier] = Optional.Absent,
    identifierType: Optional[zio.aws.iotwireless.model.IdentifierType] =
      Optional.Absent,
    partnerType: Optional[
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = Optional.Absent,
    events: Optional[
      zio.aws.iotwireless.model.EventNotificationItemConfigurations
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem = {
    import EventConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem
      .builder()
      .optionallyWith(
        identifier.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.identifier)
      .optionallyWith(identifierType.map(value => value.unwrap))(
        _.identifierType
      )
      .optionallyWith(partnerType.map(value => value.unwrap))(_.partnerType)
      .optionallyWith(events.map(value => value.buildAwsValue()))(_.events)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly =
    zio.aws.iotwireless.model.EventConfigurationItem.wrap(buildAwsValue())
}
object EventConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.EventConfigurationItem =
      zio.aws.iotwireless.model.EventConfigurationItem(
        identifier.map(value => value),
        identifierType.map(value => value),
        partnerType.map(value => value),
        events.map(value => value.asEditable)
      )
    def identifier: Optional[Identifier]
    def identifierType: Optional[zio.aws.iotwireless.model.IdentifierType]
    def partnerType
        : Optional[zio.aws.iotwireless.model.EventNotificationPartnerType]
    def events: Optional[
      zio.aws.iotwireless.model.EventNotificationItemConfigurations.ReadOnly
    ]
    def getIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getIdentifierType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.IdentifierType] =
      AwsError.unwrapOptionField("identifierType", identifierType)
    def getPartnerType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = AwsError.unwrapOptionField("partnerType", partnerType)
    def getEvents: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationItemConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem
  ) extends zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly {
    override val identifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.iotwireless.model.primitives.Identifier(value))
    override val identifierType
        : Optional[zio.aws.iotwireless.model.IdentifierType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifierType())
        .map(value => zio.aws.iotwireless.model.IdentifierType.wrap(value))
    override val partnerType
        : Optional[zio.aws.iotwireless.model.EventNotificationPartnerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partnerType())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationPartnerType.wrap(value)
        )
    override val events: Optional[
      zio.aws.iotwireless.model.EventNotificationItemConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        zio.aws.iotwireless.model.EventNotificationItemConfigurations
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem
  ): zio.aws.iotwireless.model.EventConfigurationItem.ReadOnly = new Wrapper(
    impl
  )
}
